/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.ibecorp.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.sm.BaseSMProfile;
import com.gridnine.xtrip.common.model.ibecorp.sm.BaseSMProfileIndex;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMProfileType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.db.Callback;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMSiteInterceptor
implements EntityInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SMSiteInterceptor.class);

    public double getPriority() {
        return 0.0;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!SMSite.class.equals((Object)data.getEntityType())) {
            return;
        }
        EntityReference site = data.toReference();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BaseSMProfileIndex.Property.site.name(), (Object)site));
        ArrayList<SMProfileType> types = new ArrayList<SMProfileType>();
        for (final BaseSMProfileIndex index : EntityStorage.get().search(BaseSMProfileIndex.class, query).getData()) {
            types.add(index.getProfileType());
            ss.addCallback(new Callback(){
                private static final long serialVersionUID = 7529237497133549703L;

                public void execute(SessionCallback ss1) {
                    try {
                        EntityContainer profileContainer = EntityStorage.get().resolve(index.getSource());
                        if (profileContainer != null) {
                            EntityStorage.get().actualize(((BaseSMProfile)profileContainer.getEntity()).getSite());
                            LogicalStorage.get().getEntityStorage().updateIndexes(ss1, profileContainer, profileContainer);
                        }
                    }
                    catch (Exception e) {
                        log.error(String.format("unable to rebuild index of %s", index.getSource()), (Throwable)e);
                    }
                }
            });
        }
        EntityReference defaultSite = new EntityReference("default_site_uid", SMSite.class, null);
        for (SMProfileType type : SMProfileType.values()) {
            Class profileClass;
            if (types.contains(type) || (profileClass = ProfileHelper.getProfileClass((SMProfileType)type)) == null) continue;
            EntityContainer defaultProfileContainer = EntityStorage.get().resolve(ProfileHelper.getProfile((EntityReference)defaultSite, (SMProfileType)type));
            final BaseSMProfile profile = defaultProfileContainer != null ? (BaseSMProfile)XCloneHelper.clone((XCloneable)defaultProfileContainer.getEntity()) : (BaseSMProfile)profileClass.newInstance();
            profile.setSite(site);
            ss.addCallback(new Callback(){
                private static final long serialVersionUID = -1014270710760299012L;

                public void execute(SessionCallback ss1) {
                    EntityStorage.get().save(EntityContainer.create((BaseEntity)profile), true);
                }
            });
        }
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!SMSite.class.equals((Object)data.getEntityType())) {
            return;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BaseSMProfileIndex.Property.site.name(), (Object)data.toReference()));
        for (BaseSMProfileIndex index : EntityStorage.get().search(BaseSMProfileIndex.class, query).getData()) {
            EntityStorage.get().delete(index.getSource());
        }
    }
}

