/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.ibecorp.sap.LogContent;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapLogDocument;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapLogDocumentIndex;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapLogDocumentIndexData;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import java.util.List;

public class SapLogDocumentIndexHandler
implements IndexHandler<SapLogDocument, SapLogDocumentIndex> {
    public Class<? extends BaseIndexData<SapLogDocument, SapLogDocumentIndex>> getDataClass() {
        return SapLogDocumentIndexData.class;
    }

    public Class<SapLogDocumentIndex> getIndexClass() {
        return SapLogDocumentIndex.class;
    }

    public Class<SapLogDocument> getEntityType() {
        return SapLogDocument.class;
    }

    public void create(EntityContainer<SapLogDocument> etc, Collection<BaseIndexData<SapLogDocument, SapLogDocumentIndex>> indexes) throws Exception {
        DataAggregator aggregator = new DataAggregator();
        SapLogDocumentIndexData data = new SapLogDocumentIndexData();
        this.updateData(etc, data, aggregator);
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<SapLogDocument, SapLogDocumentIndex>)data);
    }

    protected void updateData(EntityContainer<SapLogDocument> etc, SapLogDocumentIndexData data, DataAggregator aggregator) {
        SapLogDocument sapLogDocument = (SapLogDocument)etc.getEntity();
        List logContents = sapLogDocument.getLogContents();
        if (!logContents.isEmpty()) {
            LogContent last = (LogContent)CollectionUtil.getLastElement((List)logContents);
            data.setDateLastLogContent(last.getDate());
            aggregator.aggregate(last.getDate());
        }
        data.setIdComplexReserve(sapLogDocument.getIdComplexReserve());
        data.setIdReserve(sapLogDocument.getIdReserve());
        data.setType(sapLogDocument.getType());
        data.setStatus(sapLogDocument.getStatus());
        aggregator.aggregate((Object)sapLogDocument.getIdComplexReserve());
        aggregator.aggregate((Object)sapLogDocument.getIdReserve());
        aggregator.aggregate((Enum)sapLogDocument.getType());
        aggregator.aggregate((Enum)sapLogDocument.getStatus());
    }
}

