/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.ibecorp.docgen.ServiceFeeReceiptGenerator;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.model.licence2.AppConfiguration;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceFeeReceiptInterceptor
implements EntityInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public double getPriority() {
        return 3.0;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        if (!AppConfiguration.get().isIbeEnabled()) {
            return;
        }
        EntityContainer<?> bookingFileContainer = data;
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        if (!CommonIbecorpHelper.isOnlineBookingFile((BookingFile)bookingFile)) {
            return;
        }
        boolean generate = bookingFile.getReservations().stream().flatMap(item -> item.getProducts().stream()).anyMatch(item -> item instanceof Product && ((Product)item).getStatus() == ProductStatus.SELL && ((Product)item).getNextProduct() == null);
        if (!generate) {
            return;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), (Object)data.toReference()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)DocumentType.SERVICEFEERECEIPT));
        List documents = LogicalStorage.get().getEntityStorage().search(BasicDocumentIndex.class, query).getData();
        EntityReference document = documents.size() > 0 ? ((BasicDocumentIndex)documents.get(0)).getSource() : null;
        try {
            if (document != null) {
                String number = ((BaseFileDocument)((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(document).getEntity()).getName().split(".html")[0];
                String content = Optional.ofNullable(EntityStorage.get().resolve(document)).map(item -> new String(((BaseFileDocument)item.getEntity()).getContent(), StandardCharsets.UTF_8)).orElse(null);
                if (!MiscUtil.equals((Object)content, (Object)ServiceFeeReceiptGenerator.generateContext(bookingFile, number))) {
                    EntityStorage.get().delete(EntityStorage.get().resolve(document));
                    ServiceFeeReceiptGenerator.generate(bookingFileContainer, number);
                }
            } else {
                ServiceFeeReceiptGenerator.generate(bookingFileContainer, null);
            }
        }
        catch (Throwable t) {
            SysLogHelper.audit((EntityReference)data.toReference(), (String)"service-fee-receipt", (Message[])new Message[]{MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key("\u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043a\u0432\u0438\u0442\u0430\u043d\u0446\u0438\u0438 \u0441\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0433\u043e \u0441\u0431\u043e\u0440\u0430").error(t).build()});
            this.log.error("failed creating service fee receipt document", t);
        }
    }
}

