/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SiteDomainApacheRewriteAliasesInterceptor
implements EntityInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Pattern APACHE_SERVER_ALIAS_PATTERN = Pattern.compile("ServerAlias(\\t|\\s)(.*)");
    private final ReentrantLock lock = new ReentrantLock(true);

    SiteDomainApacheRewriteAliasesInterceptor() {
    }

    public double getPriority() {
        return 2.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!SMSite.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        this.lock.lock();
        this.log.info("Starting SiteDomainApacheRewriteAliasesInterceptor");
        try {
            String line;
            this.backupApacheConfFiles();
            EntityContainer<?> currentVersion = data;
            String currentDomain = ((SMSite)currentVersion.getEntity()).getDomain();
            SMSiteType currentSiteType = ((SMSite)currentVersion.getEntity()).getSiteType();
            int currentVersionNumber = data.getVersionInfo().getVersionNumber();
            this.log.info(String.format("Processing the current version [%s], [%s], version number [%s]", currentSiteType, currentDomain, String.valueOf(currentVersionNumber)));
            RandomAccessFile apacheConfFileToInclude = null;
            File apacheConfFileChecker = null;
            if (currentVersion.getVersionsCount() == 1) {
                this.log.info("The single version! Skipping exclude!");
            } else {
                int previousSavedVersionNumberToExclude = data.getVersionsCount() - 1;
                this.log.info(String.format("Loading and excluding a last saved version [%s]!", String.valueOf(previousSavedVersionNumberToExclude)));
                EntityReference ref = currentVersion.toReference();
                EntityContainer oldVersion = EntityStorage.get().load(ref.getType(), ref.getUid(), Integer.valueOf(previousSavedVersionNumberToExclude));
                if (oldVersion == null) {
                    throw new Exception(String.format("The old version [%s] is not found!", String.valueOf(previousSavedVersionNumberToExclude)));
                }
                RandomAccessFile apacheConfFileToExclude = null;
                SMSiteType oldSiteType = ((SMSite)oldVersion.getEntity()).getSiteType();
                String oldDomain = ((SMSite)oldVersion.getEntity()).getDomain();
                this.log.info(String.format("Processing the old version [%s], [%s]", oldSiteType, oldDomain));
                if (!TextUtil.isBlank((String)oldDomain) && oldSiteType != null) {
                    String line2;
                    if (currentDomain.trim().equals(oldDomain.trim()) && currentSiteType == oldSiteType) {
                        return;
                    }
                    apacheConfFileChecker = this.getApacheConfigurationFile(oldSiteType);
                    apacheConfFileToExclude = new RandomAccessFile(apacheConfFileChecker, "rw");
                    StringBuilder sb = new StringBuilder();
                    while ((line2 = apacheConfFileToExclude.readLine()) != null) {
                        String confDomain;
                        Matcher matcher = APACHE_SERVER_ALIAS_PATTERN.matcher(line2.trim());
                        if (matcher.matches() && (confDomain = matcher.group(1)).trim().equals(oldDomain.trim())) continue;
                        sb.append(line2).append("\n");
                    }
                    apacheConfFileToExclude.setLength(0L);
                    apacheConfFileToExclude.write(sb.toString().getBytes(Charset.forName("UTF-8")));
                    apacheConfFileToExclude.close();
                    this.log.info(String.format("The old configuration [%s] is rewrited successfully", apacheConfFileChecker.getAbsolutePath()));
                }
            }
            if (TextUtil.isBlank((String)currentDomain) || currentSiteType == null) {
                return;
            }
            apacheConfFileChecker = this.getApacheConfigurationFile(currentSiteType);
            apacheConfFileToInclude = new RandomAccessFile(apacheConfFileChecker, "rw");
            StringBuilder sb = new StringBuilder();
            boolean wasInAliasSection = false;
            boolean isAdded = false;
            while ((line = apacheConfFileToInclude.readLine()) != null) {
                Matcher matcher = APACHE_SERVER_ALIAS_PATTERN.matcher(line.trim());
                if (matcher.matches()) {
                    wasInAliasSection = true;
                    if (currentDomain.trim().equals(matcher.group(1).trim())) {
                        continue;
                    }
                } else if (wasInAliasSection && !isAdded) {
                    sb.append("\tServerAlias\t".concat(currentDomain)).append("\n");
                    isAdded = true;
                }
                sb.append(line).append("\n");
            }
            apacheConfFileToInclude.setLength(0L);
            apacheConfFileToInclude.write(sb.toString().getBytes(Charset.forName("UTF-8")));
            apacheConfFileToInclude.close();
            this.log.info(String.format("The new configuration [%s] is rewrited successfully, executting a restart command...", apacheConfFileChecker.getAbsolutePath()));
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("apache2ctl -k graceful");
            int res = process.waitFor();
            if (res != 0) {
                this.lock.unlock();
                throw new Exception(String.format("apache2ctl -k graceful returned exit code [%s]", Integer.toString(res)));
            }
            this.log.info("Apache is restarted succesfully!");
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.restoreConfFiles();
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("apache2ctl -k graceful");
            int res = process.waitFor();
            if (res != 0) {
                throw new Exception(String.format("apache2ctl -k graceful returned exit code [%s] again after backup, is it OK with ahe apache?", Integer.toString(res)));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private File getApacheConfigurationFile(SMSiteType siteType) {
        File result;
        if (SMSiteType.B2B == siteType) {
            String b2bConfLocation = System.getProperty("ibecorp-b2b-apache-sites-conf-file");
            if (TextUtil.isBlank((String)b2bConfLocation)) {
                return null;
            }
            result = new File(b2bConfLocation);
        } else {
            String b2cConfLocation = System.getProperty("ibecorp-b2c-apache-sites-conf-file");
            if (TextUtil.isBlank((String)b2cConfLocation)) {
                return null;
            }
            result = new File(b2cConfLocation);
        }
        if (!result.exists() || result.isDirectory()) {
            return null;
        }
        return result;
    }

    private File getApacheBackupFile(SMSiteType siteType) {
        File result;
        if (SMSiteType.B2B == siteType) {
            String b2bConfLocation = System.getProperty("ibecorp-b2b-apache-sites-conf-backup-file");
            if (TextUtil.isBlank((String)b2bConfLocation)) {
                return null;
            }
            result = new File(b2bConfLocation);
        } else {
            String b2cConfLocation = System.getProperty("ibecorp-b2c-apache-sites-conf-backup-file");
            if (TextUtil.isBlank((String)b2cConfLocation)) {
                return null;
            }
            result = new File(b2cConfLocation);
        }
        if (result.isDirectory()) {
            return null;
        }
        return result;
    }

    private void backupApacheConfFiles() throws IOException {
        FileUtils.copyFile((File)this.getApacheConfigurationFile(SMSiteType.B2B), (File)this.getApacheBackupFile(SMSiteType.B2B));
        FileUtils.copyFile((File)this.getApacheConfigurationFile(SMSiteType.B2C), (File)this.getApacheBackupFile(SMSiteType.B2C));
    }

    private void restoreConfFiles() throws IOException {
        FileUtils.copyFile((File)this.getApacheBackupFile(SMSiteType.B2B), (File)this.getApacheConfigurationFile(SMSiteType.B2B));
        FileUtils.copyFile((File)this.getApacheBackupFile(SMSiteType.B2C), (File)this.getApacheConfigurationFile(SMSiteType.B2C));
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!SMSite.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
    }
}

