/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import java.util.EnumSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowStatusInterceptor
implements EntityInterceptor {
    private static final Logger log = LoggerFactory.getLogger(WorkflowStatusInterceptor.class);
    private static final Set<ReservationStatus> IN_PROCESS_RESERVATION_STATUSES = EnumSet.of(ReservationStatus.IN_PROCESS_OF_TICKETING, ReservationStatus.IN_PROCESS_OF_VOID, ReservationStatus.IN_PROCESS_OF_REFUND, ReservationStatus.IN_PROCESS_OF_EXCHANGE);

    public double getPriority() {
        return 3.01;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) {
        if (EntityStorageHelper.isEmpty(data)) {
            return;
        }
        if (!BookingFile.class.isInstance(data.getEntity())) {
            return;
        }
        EntityContainer<?> bookingFileCtr = data;
        BookingFile bookingFile = (BookingFile)bookingFileCtr.getEntity();
        bookingFile.getReservations().stream().filter(r -> !IN_PROCESS_RESERVATION_STATUSES.contains(r.getStatus())).forEach(r -> r.setStatus(CommonIbecorpHelper.calculateReservationStatus((Reservation)r)));
        bookingFile.setWorkflowStatus(null);
    }
}

