/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.ibecorp.XreportFailDocument;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndexData;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;

public class XreportsBasicDocumentIndexHandler
implements IndexHandler<BaseFileDocument, BasicDocumentIndex> {
    public Class<? extends BaseIndexData<BaseFileDocument, BasicDocumentIndex>> getDataClass() {
        return BasicDocumentIndexData.class;
    }

    public Class<BasicDocumentIndex> getIndexClass() {
        return BasicDocumentIndex.class;
    }

    public Class<BaseFileDocument> getEntityType() {
        return BaseFileDocument.class;
    }

    public void create(EntityContainer<BaseFileDocument> etc, Collection<BaseIndexData<BaseFileDocument, BasicDocumentIndex>> indexes) throws Exception {
        if (!XreportFailDocument.class.isAssignableFrom(((BaseFileDocument)etc.getEntity()).getClass())) {
            return;
        }
        BasicDocumentIndexData data = new BasicDocumentIndexData();
        DataAggregator aggregator = new DataAggregator();
        XreportFailDocument entity = (XreportFailDocument)etc.getEntity();
        data.setCreated(entity.getCreated());
        data.setContentType(entity.getContentType());
        data.setType(DocumentType.XREPORTS_ERROR);
        data.setName(entity.getName());
        String title = entity.getTitle();
        data.setTitle(title != null && title.length() > 255 ? title.substring(0, 252) + "..." : title);
        data.setCheckSum(entity.getCheckSum());
        data.setSize(entity.getContent() == null ? 0 : entity.getContent().length);
        data.setFixed(Boolean.valueOf(entity.isFixed()));
        data.setOwner(entity.getOwner());
        aggregator.aggregate((Object)entity.getName());
        aggregator.aggregate(entity.getCreated());
        aggregator.aggregate((Enum)entity.getContentType());
        aggregator.aggregate((Object)entity.getDescription());
        aggregator.aggregate((Object)entity.getTitle());
        aggregator.aggregate((Object)entity.isFixed());
        aggregator.aggregate((Object)etc.getUid());
        indexes.add((BaseIndexData<BaseFileDocument, BasicDocumentIndex>)data);
    }
}

