/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.ibecorp.xreports.XreportsIntegrationSettings;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.ibecorp.helpers.XreportsIntegrationHelper;

public class XreportsIntegrationSettingsInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return 0.0;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!XreportsIntegrationSettings.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        XreportsIntegrationSettings settings = (XreportsIntegrationSettings)data.getEntity();
        if (!settings.isEnabled()) {
            return;
        }
        try {
            int currentSize = XreportsIntegrationHelper.getKettlePackSize(settings);
            if (settings.isCustomizePackSize()) {
                boolean success;
                if (settings.getPackSize() < 300) {
                    settings.setPackSize(300);
                } else if (settings.getPackSize() > 4000) {
                    settings.setPackSize(4000);
                }
                if (currentSize != settings.getPackSize() && !(success = XreportsIntegrationHelper.setKettlePackSize(settings.getPackSize(), settings))) {
                    IncidentsLog.reportException((String)"", (Throwable)Xeption.forDeveloper((String)"failed to set kettle pack size", (Object[])new Object[0]));
                }
            } else {
                int optimalSize = XreportsIntegrationHelper.getOptimalKettlePackSize();
                if ((double)Math.abs(currentSize - optimalSize) / (1.0 * (double)currentSize) > 0.1) {
                    boolean success = XreportsIntegrationHelper.setKettlePackSize(optimalSize, settings);
                    if (!success) {
                        IncidentsLog.reportException((String)"", (Throwable)Xeption.forDeveloper((String)"failed to set kettle pack size", (Object[])new Object[0]));
                    }
                    settings.setPackSize(optimalSize);
                }
            }
        }
        catch (Exception e) {
            IncidentsLog.reportException((String)"Exception occurred while adjusting kettle pack size", (Throwable)e);
        }
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }
}

