/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.tasks;

import com.gridnine.xtrip.common.ibecorp.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.WorkflowStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.StorageHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.List;
import org.w3c.dom.Element;

public class AddSMSitePropertyToBookingFile
extends BaseLongRunningTask<Serializable> {
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u0441\u0430\u0439\u0442 \u0434\u043b\u044f \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0445 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0439", (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void toXML(Element elm) throws Exception {
    }

    public void configure(Serializable value) throws Exception {
    }

    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("add site property to booking file started");
        if (this.isToBeStopped()) {
            this.log.debug("task is interupted");
            return;
        }
        try {
            int n = 0;
            SearchQuery organizationsSQ = new SearchQuery();
            organizationsSQ.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.AGENCY));
            List organizationRefs = StorageHelper.getEntityReferences((SearchQuery)organizationsSQ, OrganizationIndex.class);
            for (EntityReference orgRef : organizationRefs) {
                if (this.isToBeStopped()) {
                    this.log.debug(String.format("Task is interupted while processing organization [%s]", orgRef));
                    return;
                }
                byte progress = (byte)(100 * ++n / organizationRefs.size());
                if (n % 5 == 0) {
                    callback.updateProgress(progress);
                }
                this.log.debug(String.format("Processing organization [%s] %s of %s (%s%%)", orgRef, String.valueOf(n), String.valueOf(organizationRefs.size()), String.valueOf(progress)));
                EntityContainer orgCont = EntityStorage.get().resolve(orgRef);
                if (orgCont == null || orgCont.getEntity() == null) {
                    this.log.debug(String.format("Organization [%s] is not resolved", orgRef));
                    continue;
                }
                EntityContainer siteContainer = EntityStorage.get().resolve(ProfileHelper.findB2cSite((EntityReference)orgCont.toReference()));
                if (siteContainer == null || siteContainer.getEntity() == null) {
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0423 \u0430\u0433\u0435\u043d\u0441\u0442\u0432\u0430 {0} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d B2C \u0441\u0430\u0439\u0442", (Object[])new Object[]{orgRef}));
                    this.log.warn(String.format("Organization [%s] doesnt have B2C site ", orgRef));
                    continue;
                }
                SearchQuery bookingsSQ = this.buildBookingsQuery((EntityReference<Organization>)orgRef);
                List bookings = LogicalStorage.get().getEntityStorage().search(BookingFileIndex.class, bookingsSQ).getData();
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0414\u043b\u044f \u0430\u0433\u0435\u043d\u0441\u0442\u0432\u0430 {0} \u043d\u0430\u0439\u0434\u0435\u043d\u043e {1} \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0445 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0439", (Object[])new Object[]{orgRef, bookings.size()}));
                this.log.debug(String.format("Organization [%s] has [%d] actual bookings", orgRef, bookings.size()));
                for (BookingFileIndex idx : bookings) {
                    EntityContainer bookingFileCtr = null;
                    try {
                        bookingFileCtr = EntityStorage.get().resolve(idx.getSource());
                    }
                    catch (Exception e) {
                        this.log.error(String.format("Unable to load a booking from index [%s], skipping", idx.getUid()));
                        continue;
                    }
                    if (bookingFileCtr == null || bookingFileCtr.getEntity() == null) {
                        this.log.error(String.format("Booking from index [%s] is not resolved", idx.getUid()));
                        continue;
                    }
                    try {
                        ((BookingFile)bookingFileCtr.getEntity()).setSite(siteContainer.toReference());
                        bookingFileCtr.getVersionInfo().setDataSource("adding a site property");
                        EntityStorage.get().save(bookingFileCtr, true);
                    }
                    catch (Exception e) {
                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f [%s]", idx.getUid()), (Object[])new Object[0]));
                        this.log.error(String.format("Error updatting booking file [%s]", idx.getUid()), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0438 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u0441\u0430\u0439\u0442 \u0432 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435", (Object[])new Object[0]));
            this.log.error(String.format("Error occured during add site property to booking file", new Object[0]), (Throwable)e);
        }
        callback.taskFinished();
        this.log.debug("add site property to booking file finished");
    }

    private SearchQuery buildBookingsQuery(EntityReference<Organization> orgRef) {
        SearchQuery sq = new SearchQuery();
        sq.getCriteria().getCriterions().add(SearchCriterion.eq((String)BookingFileIndex.Property.agency.name(), orgRef));
        sq.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.in((String)BookingFileIndex.Property.workflowStatus.name(), (Object[])new Object[]{WorkflowStatus.BOOKING, WorkflowStatus.TO_BE_PAYED, WorkflowStatus.ERROR}), SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)BookingFileIndex.Property.reservationStatuses.name(), (Object)ReservationStatus.BOOKING), SearchCriterion.contains((String)BookingFileIndex.Property.reservationStatuses.name(), (Object)ReservationStatus.ERROR)})}));
        sq.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BookingFileIndex.Property.failedCancelling.name(), (Object)Boolean.FALSE), SearchCriterion.eq((String)BookingFileIndex.Property.failedCancelling.name(), null)}));
        return sq;
    }
}

