/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.tasks;

import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.IssueStatus;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.Post;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.SimpleIssue;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class CheckTicketingTimeoutScheduleTask
extends BaseScheduledTask {
    private static final String TASK_ID = "check-ticketing-timeout-task";
    private Date nextFireTime;

    protected void configure(Properties properties) throws Exception {
        this.nextFireTime = (Date)properties.get("nextFireTime");
    }

    protected void doJob() throws Exception {
        LockUtil.lock((String)TASK_ID, (long)1L, (TimeUnit)TimeUnit.SECONDS, () -> {
            SearchQuery searchQuery = new SearchQuery();
            searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.reservationStatus.name(), (Object)ReservationStatus.IN_PROCESS_OF_TICKETING), SearchCriterion.eq((String)ProductIndex.Property.reservationStatus.name(), (Object)ReservationStatus.IN_PROCESS_OF_VOID), SearchCriterion.eq((String)ProductIndex.Property.reservationStatus.name(), (Object)ReservationStatus.IN_PROCESS_OF_EXCHANGE)}));
            searchQuery.getCriteria().getCriterions().add(SearchCriterion.lt((String)ProductIndex.Property.reservationDate.name(), (Object)MiscUtil.addMinutesToDate((Date)this.nextFireTime, (int)-120)));
            searchQuery.getCriteria().getCriterions().add(SearchQueryHelper.getGdsNameSearchCriterionForProductIndex((GdsName)GdsName.TA_NDC));
            searchQuery.getPreferredProperties().add(ProductIndex.Property.reservationUid.name());
            List indexes = EntityStorage.get().search(ProductIndex.class, searchQuery).getData();
            for (ProductIndex productIndex : indexes) {
                EntityContainer bookingCtr = EntityStorage.get().resolve(productIndex.getSource());
                Reservation reservation = BookingHelper.findReservationByUid((BookingFile)((BookingFile)bookingCtr.getEntity()), (String)productIndex.getReservationUid());
                if (reservation == null) continue;
                reservation.setStatus(ReservationStatus.ERROR);
                this.createIssue((EntityContainer<BookingFile>)bookingCtr);
                SysLogHelper.audit((EntityReference)bookingCtr.toReference(), (String)TASK_ID, (Message[])new Message[]{SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u0432\u044b\u043f\u0438\u0441\u043a\u0438", (Object[])new Object[0])});
                bookingCtr.getVersionInfo().setDataSource(TASK_ID);
                EntityStorage.get().save(bookingCtr, true);
            }
        }, () -> {});
    }

    private void createIssue(EntityContainer<BookingFile> bookingCtr) {
        BookingFile booking = (BookingFile)bookingCtr.getEntity();
        String title = "\u0412\u044b\u043f\u0438\u0441\u043a\u0430 \u0437\u0430\u043a\u0430\u0437\u0430 \u2116" + booking.getNumber();
        String description = "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u0432\u044b\u043f\u0438\u0441\u043a\u0438";
        SimpleIssue issue = new SimpleIssue();
        EntityContainer issueCtr = EntityContainer.create((BaseEntity)issue);
        issue.setTitle(title);
        issue.setDescription(description);
        issue.setCreateDate(new Date());
        issue.setStatus(IssueStatus.NEW);
        issue.setUpdateDate(new Date());
        Post post = new Post();
        post.setDateCreated(new Date());
        post.setContent(description);
        issue.getPosts().add(post);
        issue.setBooking(bookingCtr.toReference());
        issue.setAgency(booking.getAgency());
        issue.setSubagency(BookingHelper.getSubagency((BookingFile)booking));
        issue.setClient(booking.getCustomerProfile());
        issueCtr.getVersionInfo().setDataSource(TASK_ID);
        EntityStorage.get().save(issueCtr, true);
    }
}

