/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.tasks;

import com.gridnine.xtrip.common.ibecorp.l10n.Messages;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.ibecorp.PersonNoticesDetailsIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.notices.RestNoticesHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class DeleteOldPersonNoticesDetailsTask
extends BaseLongRunningTask<Serializable> {
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.DeleteOldPersonNoticesDetailsTask, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void toXML(Element elm) throws Exception {
    }

    public void configure(Serializable value) throws Exception {
    }

    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        if (this.isToBeStopped()) {
            this.log.debug("task is interupted");
            return;
        }
        Date minActiveDate = RestNoticesHelper.getMinActiveDate();
        EntityStorage storage = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.lt((String)PersonNoticesDetailsIndex.Property.lastUpdateDate.name(), (Object)minActiveDate));
        query.getPreferredProperties().add(PersonNoticesDetailsIndex.Property.person.name());
        List indexes = storage.search(PersonNoticesDetailsIndex.class, query).getData();
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041d\u0430\u0439\u0434\u0435\u043d\u043e {0} \u0437\u0430\u043f\u0438\u0441\u0435\u0439.", (Object[])new Object[]{indexes.size()}));
        if (indexes.size() == 0) {
            callback.taskFinished();
            return;
        }
        Map personsMap = indexes.stream().collect(Collectors.groupingBy(PersonNoticesDetailsIndex::getPerson, MiscUtil.getListCollector(PersonNoticesDetailsIndex::getSource)));
        boolean wasStopped = false;
        int deleted = 0;
        int personProcessed = 0;
        int total = personsMap.size();
        int current = 0;
        byte progress = 0;
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041d\u0430\u0439\u0434\u0435\u043d\u043e {0} \u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u043e\u0432.", (Object[])new Object[]{total}));
        for (Map.Entry entry : personsMap.entrySet()) {
            byte newProgress;
            if (this.isToBeStopped()) {
                this.log.debug("task is interupted");
                wasStopped = true;
                break;
            }
            EntityReference personRef = entry.getKey();
            Collection personNoticesRefs = (Collection)entry.getValue();
            if (this.needDelete((EntityReference<Person>)personRef, minActiveDate)) {
                for (EntityReference personNoticesRef : personNoticesRefs) {
                    storage.delete(personNoticesRef);
                    ++deleted;
                }
                ++personProcessed;
            }
            if (progress == (newProgress = (byte)(++current * 100 / total))) continue;
            progress = newProgress;
            callback.updateProgress(progress);
        }
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e {0} \u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u043e\u0432 \u0438\u0437 {1}", (Object[])new Object[]{current, total}));
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0423\u0434\u0430\u043b\u0435\u043d\u043e {0} \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u0434\u043b\u044f {1} \u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u043e\u0432", (Object[])new Object[]{deleted, personProcessed}));
        if (!wasStopped) {
            callback.taskFinished();
        }
    }

    private boolean needDelete(EntityReference<Person> personRef, Date minActiveDate) {
        EntityContainer personCtr = EntityStorage.get().resolve(personRef);
        if (personCtr == null) {
            return true;
        }
        String loginName = ((Person)personCtr.getEntity()).getLoginName();
        if (TextUtil.isBlank((String)loginName)) {
            return true;
        }
        UserAccount userAccount = (UserAccount)AssetsStorage.get().find(UserAccount.class, UserAccount.Property.loginName.name(), (Object)loginName);
        return userAccount == null || userAccount.getLastLoginDate() == null || userAccount.getLastLoginDate().before(minActiveDate);
    }
}

