/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.tasks;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class DeleteSyncReservationLogsTask
extends BaseScheduledTask {
    public static final String MAX_HOTEL_CHECKOUT_DATE_ALIAS = "maxhotelcheckoutdate";
    public static final String CONTAINER_UID_ALIAS = "containeruid";
    private int daysToKeep;
    private boolean dryRun;

    protected void configure(Properties properties) throws Exception {
        this.daysToKeep = Integer.parseInt(properties.getProperty("daysToKeep"));
        this.dryRun = Boolean.parseBoolean(properties.getProperty("dryRun"));
    }

    protected void doJob() throws Exception {
        this.log.debug("started");
        Set<String> docOwners = this.getDocOwners();
        this.log.debug("got {} doc owners", (Object)docOwners.size());
        Set<String> matchingBfs = this.getMatchingBfs(this.daysToKeep);
        this.log.debug("got {} matching bfs", (Object)matchingBfs.size());
        docOwners.retainAll(matchingBfs);
        this.log.debug("retained {} doc owners", (Object)docOwners.size());
        for (String owner : docOwners) {
            if (this.isToBeStopped()) {
                this.log.debug("stopping due to to be stopped");
                break;
            }
            this.log.debug("deleting sync-reservation log for booking file {}", (Object)owner);
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.like((String)BasicDocumentIndex.Property.name.name(), (String)"sync-reservation%"));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), (Object)new EntityReference(owner, BookingFile.class, null)));
            query.getPreferredProperties().add(BasicDocumentIndex.Property.owner.name());
            for (BasicDocumentIndex idx : EntityStorage.get().search(BasicDocumentIndex.class, query).getData()) {
                if (!this.dryRun) {
                    EntityStorage.get().delete(idx.getSource());
                }
                this.log.debug("deleted document {}", (Object)idx.getSource().getUid());
            }
        }
        this.log.debug("finished");
    }

    private Set<String> getDocOwners() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.like((String)BasicDocumentIndex.Property.name.name(), (String)"sync-reservation%"));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)BasicDocumentIndex.Property.owner.name(), null));
        query.getPreferredProperties().add(BasicDocumentIndex.Property.owner.name());
        return EntityStorage.get().search(BasicDocumentIndex.class, query).getData().stream().map(BasicDocumentIndex::getOwner).map(EntityReference::getUid).collect(Collectors.toSet());
    }

    private Set<String> getMatchingBfs(int daysToKeep) {
        ProjectionQuery query = new ProjectionQuery();
        query.getProjections().add(Projection.group((String)"containerUid", (String)CONTAINER_UID_ALIAS));
        query.getProjections().add(Projection.max((String)MainHotelProductIndex.Property.hotelCheckOutDate.name(), (String)MAX_HOTEL_CHECKOUT_DATE_ALIAS));
        Date threshold = MiscUtil.addDaysToDate((Date)MiscUtil.clearTime((Date)new Date()), (int)(-(daysToKeep + 1)));
        return EntityStorage.get().search(MainHotelProductIndex.class, query).getData().stream().filter(m -> m.get(MAX_HOTEL_CHECKOUT_DATE_ALIAS) != null && ((Date)m.get(MAX_HOTEL_CHECKOUT_DATE_ALIAS)).before(threshold)).map(m -> (String)m.get(CONTAINER_UID_ALIAS)).collect(Collectors.toSet());
    }
}

