/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.tasks;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.BaseSMProfileIndex;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMProfileType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep3Settings;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.List;
import org.w3c.dom.Element;

public class DisableNationalPassportTask
extends BaseLongRunningTask<Serializable> {
    public void configure(Serializable configuration) throws Exception {
    }

    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"\u041e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0442\u0438\u043f\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \"\u041d\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0441\u0441\u043f\u043e\u0440\u0442\" \u0438\u0437 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u043f\u044f\u0442\u043e\u0433\u043e \u0448\u0430\u0433\u0430 \u0434\u043b\u044f \u0430\u0433\u0435\u043d\u0441\u0442\u0432", (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
    }

    public void fromXML(Element elm) throws Exception {
    }

    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("disabling a national passport document task from SMStep5Settings started");
        if (this.isToBeStopped()) {
            this.log.debug("task is interupted");
            return;
        }
        try {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BaseSMProfileIndex.Property.profileType.name(), (Object)SMProfileType.STEP3_SETTINGS));
            List step5indexes = EntityStorage.get().search(BaseSMProfileIndex.class, query).getData();
            int n = 0;
            for (BaseSMProfileIndex step5index : step5indexes) {
                if (this.isToBeStopped()) {
                    this.log.debug("task is interupted");
                    return;
                }
                byte progress = (byte)(100 * ++n / step5indexes.size());
                this.log.debug(String.format("processing settings %s of %s (%s%%)", String.valueOf(n), String.valueOf(step5indexes.size()), String.valueOf(progress)));
                if (n % 5 == 0) {
                    callback.updateProgress(progress);
                }
                EntityContainer step5settngs = EntityStorage.get().resolve(step5index.getSource());
                ((SMStep3Settings)step5settngs.getEntity()).getNotAllowedDocuments().add(PassportType.PASSPORT);
                EntityStorage.get().save(step5settngs, true);
            }
        }
        catch (Exception e) {
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438 \u0442\u0438\u043f\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \"\u041d\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0441\u0441\u043f\u043e\u0440\u0442\" \u0438\u0437 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u043f\u044f\u0442\u043e\u0433\u043e \u0448\u0430\u0433\u0430 \u0434\u043b\u044f \u0430\u0433\u0435\u043d\u0441\u0442\u0432", (Object[])new Object[0]));
            this.log.error(String.format("error occured during disabling a national passport document task from SMStep5Settings", new Object[0]), (Throwable)e);
        }
        callback.taskFinished();
        this.log.debug("disabling a national passport document task from SMStep5Settings finished");
    }
}

