/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.tasks;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ExpiryWarningTime;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.misc.StorageUtil;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.ibecorp.notifications.ExpiringTimeLimitNotification;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.model.mail.MailSender;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class ExpiringTimeLimitNotificationScheduleTask
extends BaseScheduledTask {
    public static final String START_WARNING_DATE_PARAM_NAME = "startWarningDate";
    public static final String START_WARNING_DATE_PATTERN = "dd.MM.yyyy";
    private Date nextFireTime;
    private static final List<ProductStatus> PRODUCT_STATUSES = Arrays.asList(ProductStatus.BOOKING, ProductStatus.INTENTION);

    protected void configure(Properties properties) {
        this.nextFireTime = (Date)properties.get("nextFireTime");
    }

    protected void doJob() throws Exception {
        this.log.debug("expiring time limit notification task started");
        this.warnAboutExpiringTimeLimit();
        this.log.debug("expiring time limit notification task finished");
    }

    private void warnAboutExpiringTimeLimit() throws Exception {
        MailSender sender = (MailSender)Environment.getPublished(MailSender.class);
        if (!sender.isEnabled()) {
            this.log.debug("notifications not sent because mail service is disabled");
            return;
        }
        SearchQuery query = this.buildQuery();
        Map<Reservation, EntityContainer<BookingFile>> reservationToBookingCtrMap = this.createReservationToBookingCtrMap(query);
        reservationToBookingCtrMap.forEach(this::sendNotification);
    }

    private SearchQuery buildQuery() throws Exception {
        String startWarningDateStr = this.getParameter(START_WARNING_DATE_PARAM_NAME);
        Date startWarningDate = TextUtil.nonBlank((String)startWarningDateStr) ? new SimpleDateFormat(START_WARNING_DATE_PATTERN).parse(startWarningDateStr) : new Date();
        SearchQuery query = new SearchQuery();
        List criteria = query.getCriteria().getCriterions();
        criteria.add(SearchCriterion.in((String)ProductIndex.Property.status.name(), (Object[])PRODUCT_STATUSES.toArray()));
        criteria.add(SearchCriterion.between((String)ProductIndex.Property.warningAboutExpiring.name(), (Object)startWarningDate, (Object)this.nextFireTime));
        query.getPreferredProperties().add("containerUid");
        return query;
    }

    private Map<Reservation, EntityContainer<BookingFile>> createReservationToBookingCtrMap(SearchQuery query) {
        HashMap<Reservation, EntityContainer<BookingFile>> reservationToBookingCtrMap = new HashMap<Reservation, EntityContainer<BookingFile>>();
        Set bookingRefs = EntityStorage.get().search(ProductIndex.class, query).getData().stream().map(ProductIndex::getSource).collect(Collectors.toSet());
        for (EntityReference bookingRef : bookingRefs) {
            try {
                LockUtil.lock((EntityReference)bookingRef, bfCtr -> {
                    if (bfCtr == null) {
                        return;
                    }
                    BookingFile booking = (BookingFile)bfCtr.getEntity();
                    boolean save = false;
                    ArrayList<Reservation> processed = new ArrayList<Reservation>();
                    for (Product product : BookingHelper.getProductsList((BookingFile)booking, Product.class)) {
                        Reservation reservation;
                        if (!PRODUCT_STATUSES.contains(product.getStatus()) || processed.contains(reservation = product.getReservation())) continue;
                        for (ExpiryWarningTime expiryWarningTime : reservation.getTimeLimitExpiryWarningTime()) {
                            if (expiryWarningTime.isPassed() || expiryWarningTime.getTimeLimitExpiryWarningTime() == null || !expiryWarningTime.getTimeLimitExpiryWarningTime().before(this.nextFireTime)) continue;
                            expiryWarningTime.setPassed(true);
                            reservationToBookingCtrMap.put(reservation, (EntityContainer<BookingFile>)bfCtr);
                            save = true;
                        }
                        processed.add(reservation);
                    }
                    if (save) {
                        bfCtr.getVersionInfo().setDataSource("notification-about-expiring-time-limit");
                        EntityStorage.get().save(bfCtr, true);
                    }
                });
            }
            catch (Exception e) {
                this.log.error("process booking " + bookingRef.getCaption() + " (" + bookingRef.getUid() + ") failed", (Throwable)e);
            }
        }
        return reservationToBookingCtrMap;
    }

    private void sendNotification(Reservation reservation, EntityContainer<BookingFile> bfCtr) {
        Person agent = (Person)StorageUtil.getEntity((EntityReference)reservation.getBookingAgent());
        String displayedLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation);
        if (agent == null || TextUtil.isBlank((String)ProfileHelper.getCommunicationEmail((List)agent.getCommunications()))) {
            this.log.debug(String.format("notification for PNR:%s not sent because agent's email undefined", displayedLocator));
            return;
        }
        this.log.debug(String.format("sending notification for PNR:%s", displayedLocator));
        EntityReference bfRef = bfCtr.toReference();
        NotificationParameters parameters = new NotificationParameters(reservation, (EntityReference<BookingFile>)bfRef);
        NotificationHelper.sendNotification(() -> new ExpiringTimeLimitNotification(parameters, reservation), bfRef, false);
    }
}

