/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.tasks;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.StorageHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import org.w3c.dom.Element;

public class FixRuleTargetsTask
extends BaseLongRunningTask<Serializable> {
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"\u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u041f\u0440\u0438\u043c\u0435\u043d\u0438\u043c\u043e \u043a \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u0445", (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void toXML(Element elm) throws Exception {
    }

    public void configure(Serializable value) throws Exception {
    }

    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        if (this.isToBeStopped()) {
            this.log.debug("task is interupted");
            return;
        }
        for (EntityReference ctrRef : StorageHelper.getEntityReferences((SearchQuery)new SearchQuery(), ContractIndex.class)) {
            if (this.isToBeStopped()) {
                this.log.debug("task is interupted");
                return;
            }
            this.log.debug("updating contract " + ctrRef);
            try {
                EntityContainer ctr = EntityStorage.get().resolve(ctrRef);
                if (((Contract)ctr.getEntity()).getRuleSet() == null) {
                    this.log.debug("contract " + ctrRef + " has no rules");
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0434\u043e\u0433\u043e\u0432\u043e\u0440 {0} \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043f\u0440\u0430\u0432\u0438\u043b", (Object[])new Object[]{ctrRef}));
                    continue;
                }
                boolean changed = false;
                for (RuleSettings rs : ((Contract)ctr.getEntity()).getRuleSet().getRules()) {
                    if (rs.getTarget() != null) continue;
                    rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
                    changed = true;
                }
                if (!changed) {
                    this.log.debug("contract " + ctrRef + " has no undefined rule targets");
                    continue;
                }
                ctr.getVersionInfo().setDataSource("server-task");
                ctr.getVersionInfo().setVersionNotes("modified by task " + ((Object)((Object)this)).getClass().getSimpleName());
                LogicalStorage.get().getEntityStorage().save(ctr, true);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440 {0}", (Object[])new Object[]{ctrRef}));
            }
            catch (Throwable e) {
                this.log.error("unable to update contract " + ctrRef, e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440 {0}", (Throwable)e, (Object[])new Object[]{ctrRef}));
            }
        }
        callback.taskFinished();
    }

    public boolean isIndefinite() {
        return true;
    }
}

