/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.tasks;

import com.gridnine.xtrip.common.gds.rules.Actions;
import com.gridnine.xtrip.common.gds.rules.FilteringCategories;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.RulesHolder;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.w3c.dom.Element;

public class P\u0421\u0421ToPCCRefResolveTask
extends BaseLongRunningTask<Serializable> {
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"\u041f\u0440\u0438\u0432\u0435\u0434\u0435\u043d\u0438\u0435 PCC \u043a PCCReference \u0434\u043b\u044f \u043f\u0440\u0430\u0432\u0438\u043b \u0441\u0430\u0439\u0442\u043e\u0432", (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void toXML(Element elm) throws Exception {
    }

    public void configure(Serializable value) throws Exception {
    }

    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        throw Xeption.forDeveloper((String)"Task is deprecated", (Object[])new Object[0]);
    }

    private void replacePCCtoPCCRef(LongRunningTask.EventsCallback callback, EntityContainer<SalesPoint> spCont, SalesPoint sp, RulesHolder rh, FilteringCategories filteringCategory, Actions oldAction, Actions newAction) throws Exception {
        for (RuleSettings rSets : rh.getRuleSet().getRules()) {
            if (rSets.getFilteringCategory() != filteringCategory) continue;
            for (RuleResult rResults : rSets.getResults()) {
                if (rResults.getAction() != null) continue;
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 Action \u0434\u043b\u044f \u043f\u0440\u0430\u0432\u0438\u043b\u0430 {0} c \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435\u043c {1} \u0432 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 {2}", (Object[])new Object[]{rSets.getUid(), rSets.getName(), filteringCategory.name()}));
                this.log.debug(String.format("Found unsupported action for rule [%s] with name [%s] and category [%s]", rSets.getUid(), rSets.getName(), filteringCategory.name()));
                String actionId = null;
                try {
                    Field f = rResults.getClass().getDeclaredField("actionId");
                    f.setAccessible(true);
                    actionId = (String)f.get(rResults);
                }
                catch (Exception e) {
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 actionId \u0434\u043b\u044f \u043f\u0440\u0430\u0432\u0438\u043b\u0430 {0} c \u043d\u0430\u0441\u0437\u0432\u0430\u043d\u0438\u0435\u043c {1} \u0432 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 {2}", (Object[])new Object[]{rSets.getUid(), rSets.getName(), filteringCategory.name()}));
                    this.log.error(String.format("Error accessing action for rule [%s] with name [%s] and category [%s]", rSets.getUid(), rSets.getName(), filteringCategory.name()));
                    throw e;
                }
                if (oldAction.name().equals(actionId)) {
                    String pccCode = (String)rResults.getValue();
                    Pcc pcc = this.findPcc(sp, pccCode);
                    if (pcc == null) {
                        this.log.warn(String.format("Cannot find PCC [%s] for SalesPoint [%s]", pccCode, sp));
                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0423 \u0442\u043e\u0447\u043a\u0438 \u043f\u0440\u043e\u0434\u0430\u0436 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 {0} PCC {1}", (Object[])new Object[]{sp, pccCode}));
                        continue;
                    }
                    NestedEntityReference newValue = new NestedEntityReference(spCont.toReference(), pcc.getUid(), pcc.getClass(), pcc.getCode());
                    rResults.setAction((RuleAction)newAction);
                    rResults.setValue((Object)newValue);
                    this.log.debug(String.format("PCC [%s] is replaced for SalesPoint [%s]", pccCode, sp));
                    continue;
                }
                String message = String.format("The actionId [%s] is not handled because is not in allowed oldActions. Rule [%s] [%s] [%s]", actionId, rSets.getUid(), rSets.getName(), filteringCategory.name());
                this.log.error(message);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"ActionId {0} \u043d\u0435 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d \u0442.\u043a \u043d\u0435 \u0432\u0445\u043e\u0434\u0438\u0442 \u0432 \u0441\u043f\u0438\u0441\u043e\u043a \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043d\u044b\u0445. \u041f\u0440\u0430\u0432\u0438\u043b\u043e {1} {2} {3}", (Object[])new Object[]{actionId, rSets.getUid(), rSets.getName(), filteringCategory.name()}));
                throw new Exception(message);
            }
        }
    }

    private Pcc findPcc(SalesPoint sp, String code) {
        for (Pcc pcc : sp.getPccs()) {
            if (!TextUtil.isSame((String)pcc.getCode(), (String)code, (boolean)true)) continue;
            return pcc;
        }
        return null;
    }
}

