/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.tasks;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentIndex;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class ReindexProductsFromShipmentsTask
extends BaseLongRunningTask<Serializable> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        Date date = new Date();
        Date startDate = MiscUtil.clearTime((Date)date);
        Date endDate = MiscUtil.setDayEndTime((Date)date);
        HashSet bookings = new HashSet();
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041f\u0435\u0440\u0435\u0438\u043d\u0434\u0435\u043a\u0441\u0438\u0440\u0443\u0435\u043c \u0437\u0430\u043a\u0430\u0437\u044b \u0438\u0437 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0439 \u0437\u0430 {0}", (Object[])new Object[]{new SimpleDateFormat("yyyy-MM-dd").format(date)}));
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ShipmentIndex.Property.date.name(), (Object)startDate));
        query.getCriteria().getCriterions().add(SearchCriterion.le((String)ShipmentIndex.Property.date.name(), (Object)endDate));
        List shipmentsIndexes = EntityStorage.get().search(ShipmentIndex.class, query).getData();
        int size = shipmentsIndexes.size();
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041d\u0430\u0439\u0434\u0435\u043d\u043e {0} \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0439", (Object[])new Object[]{size}));
        if (size == 0) {
            callback.updateProgress((byte)100);
            callback.taskFinished();
            return;
        }
        int lastProgress = 0;
        for (int idx = 0; idx < size; ++idx) {
            try {
                EntityStorageContext ctx = EntityStorageHelper.createContext();
                EntityContainer shipmentCtr = EntityStorageHelper.resolve((EntityReference)((ShipmentIndex)shipmentsIndexes.get(idx)).getSource(), (EntityStorageContext)ctx);
                if (shipmentCtr == null) continue;
                this.log.debug("processing shipment " + ((Shipment)shipmentCtr.getEntity()).getNumber());
                FinanceDocumentHelper.getBillingItems((List)((Shipment)shipmentCtr.getEntity()).getBillingItems(), (EntityStorageContext)ctx).forEach(item -> {
                    EntityReference<BookingFile> bookingRef = this.toBookingFileReference(item.getProduct());
                    if (bookingRef != null && bookings.add(bookingRef)) {
                        this.log.debug("booking added " + bookingRef.getUid());
                    }
                    for (NestedEntityReference fop : item.getFopComponents()) {
                        bookingRef = this.toBookingFileReference(fop);
                        if (!bookings.add(bookingRef)) continue;
                        this.log.debug("booking added " + bookingRef.getUid());
                    }
                });
                continue;
            }
            catch (Exception e) {
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044e {0}", (Object[])new Object[]{((ShipmentIndex)shipmentsIndexes.get(idx)).getSource()}));
                continue;
            }
            finally {
                int progress = idx * 30 / size;
                if (progress > lastProgress + 5) {
                    lastProgress = progress;
                    callback.updateProgress((byte)progress);
                }
            }
        }
        int size2 = bookings.size();
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041d\u0430\u0439\u0434\u0435\u043d\u043e {0} \u0437\u0430\u043a\u0430\u0437\u043e\u0432", (Object[])new Object[]{size2}));
        int lastProgress2 = 30;
        int idx = 0;
        for (EntityReference bookingRef : bookings) {
            String bookingTitle = bookingRef.getUid();
            try {
                EntityContainer bookingCtr = EntityStorage.get().resolve(bookingRef);
                if (bookingCtr == null) continue;
                bookingTitle = ((BookingFile)bookingCtr.getEntity()).getNumber();
                this.log.debug("reindexing booking " + bookingTitle);
                LogicalStorage.get().getEntityStorage().updateIndexes(bookingCtr, bookingCtr, true);
            }
            catch (Exception e) {
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u0437\u0430\u043a\u0430\u0437 {0}", (Object[])new Object[]{bookingTitle}));
            }
            finally {
                int progress = 30 + ++idx * 70 / size2;
                if (progress <= lastProgress2 + 5) continue;
                lastProgress2 = progress;
                callback.updateProgress((byte)progress);
            }
        }
        callback.updateProgress((byte)100);
        callback.taskFinished();
    }

    private EntityReference<BookingFile> toBookingFileReference(NestedEntityReference<BookingFile, ?> ref) {
        if (ref == null) {
            return null;
        }
        return new EntityReference(ref.getUid(), BookingFile.class, null);
    }

    public void configure(Serializable configuration) throws Exception {
    }

    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"\u041f\u0435\u0440\u0435\u0438\u043d\u0434\u0435\u043a\u0441\u0430\u0446\u0438\u044f \u0437\u0430\u043a\u0430\u0437\u043e\u0432 \u0438\u0437 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0439", (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
    }

    public void fromXML(Element elm) throws Exception {
    }
}

