/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.tasks;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.BaseSMProfile;
import com.gridnine.xtrip.common.model.ibecorp.sm.BaseSMProfileIndex;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.storage.common.StorageHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.List;
import org.w3c.dom.Element;

public class RemoveUnbindSiteSettingsTask
extends BaseLongRunningTask<Serializable> {
    public void toXML(Element elm) throws Exception {
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void configure(Serializable configuration) throws Exception {
    }

    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0431\u0435\u0441\u043f\u0440\u0438\u0437\u043e\u0440\u043d\u044b\u0445 (\u043d\u0435\u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0445 \u043a \u0441\u0430\u0439\u0442\u0443) \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u0441\u0430\u0439\u0442\u0430", (Object[])new Object[0]);
    }

    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("Remove Unbind SiteSettings Task started");
        if (this.isToBeStopped()) {
            this.log.debug("task is interupted");
            return;
        }
        try {
            int n = 0;
            List siteReferences = StorageHelper.getEntityReferences((SearchQuery)new SearchQuery(), BaseSMProfileIndex.class);
            for (EntityReference settingsRef : siteReferences) {
                if (this.isToBeStopped()) {
                    this.log.debug(String.format("Task is interupted while Remove Unbind SiteSettings Task [%s]", settingsRef));
                    return;
                }
                byte progress = (byte)(100 * ++n / siteReferences.size());
                if (n % 5 == 0) {
                    callback.updateProgress(progress);
                }
                this.log.debug(String.format("Processing [%s] site %s of %s (%s%%)", settingsRef, String.valueOf(n), String.valueOf(siteReferences.size()), String.valueOf(progress)));
                EntityContainer settingsCont = EntityStorage.get().resolve(settingsRef);
                if (settingsCont == null) {
                    EntityStorage.get().delete(settingsRef);
                    continue;
                }
                BaseSMProfile profile = (BaseSMProfile)settingsCont.getEntity();
                if (profile == null) {
                    EntityStorage.get().delete(settingsRef);
                    continue;
                }
                EntityReference siteRef = profile.getSite();
                if (siteRef == null) {
                    EntityStorage.get().delete(settingsRef);
                    continue;
                }
                EntityContainer siteCont = EntityStorage.get().resolve(siteRef);
                if (siteCont != null && siteCont.getEntity() != null) continue;
                EntityStorage.get().delete(settingsRef);
            }
        }
        catch (Exception e) {
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"Error occured during Remove Unbind SiteSettings Task", (Object[])new Object[0]));
            this.log.error(String.format("Error occured during Remove Unbind SiteSettings Task", new Object[0]), (Throwable)e);
        }
        callback.taskFinished();
        this.log.debug("Remove Unbind SiteSettings Task is finished");
    }
}

