/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.tasks;

import com.gridnine.xtrip.common.ibecorp.model.ResendDataToXreportsTaskConfiguration;
import com.gridnine.xtrip.common.ibecorp.storage.XreportsBookingMarkerObject;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseQueryObjectsTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class ResendDataToXreportsTask
extends BaseLongRunningTask<ResendDataToXreportsTaskConfiguration> {
    private ResendDataToXreportsTaskConfiguration configuration;
    private boolean firstPhaseCompleted;
    private CreateMarkerObjectsTask delegate;

    protected void doJob(final LongRunningTask.EventsCallback callback) throws Exception {
        int totalCount;
        if (!this.configuration.isSecondPhase() && !this.firstPhaseCompleted) {
            this.delegate = new CreateMarkerObjectsTask(this.configuration);
            this.delegate.doJob(new LongRunningTask.EventsCallback(){

                public void addEvent(String eventId, Message description) {
                    callback.addEvent(eventId, description);
                }

                public void updateProgress(byte progress) {
                    callback.updateProgress((byte)((double)progress * 0.5));
                }

                public void taskFinished() {
                    callback.updateProgress((byte)50);
                }
            });
        } else {
            callback.updateProgress((byte)50);
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0444\u0430\u0437\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043c\u0430\u0440\u043a\u0435\u0440\u043d\u044b\u0445 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432", (Object[])new Object[0]));
        }
        Date now = new Date();
        int count = totalCount = this.getCount(now);
        int lastProgress = 50;
        while (count != 0 && !this.isToBeStopped()) {
            Thread.sleep(TimeUnit.SECONDS.toMillis(30L));
            count = this.getCount(now);
            int progress = (int)(50.0 + 50.0 * (double)(totalCount - count) / (double)totalCount);
            if (progress <= lastProgress + 5) continue;
            lastProgress = progress;
            callback.updateProgress((byte)progress);
            callback.addEvent("progress", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)String.format("\u043f\u0435\u0440\u0435\u043a\u0430\u0447\u0435\u043d\u043e %s \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0438\u0437 %s", totalCount - count, totalCount), (Object[])new Object[0]));
        }
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430 \u043f\u0435\u0440\u0435\u0433\u043e\u043d\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445", (Object[])new Object[0]));
        callback.taskFinished();
    }

    private int getCount(Date now) {
        ProjectionQuery query = new ProjectionQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.le((String)BaseAsset.Property.modified.name(), (Object)now));
        query.getProjections().add(Projection.count((String)"uid", (String)"_uid"));
        return AssetsStorage.get().search(XreportsBookingMarkerObject.class, query).getInt("_uid");
    }

    public void configure(ResendDataToXreportsTaskConfiguration configuration) throws Exception {
        this.configuration = configuration;
    }

    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"\u041f\u0435\u0440\u0435\u043a\u0430\u0447\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u041e\u0442\u0447\u0435\u0442\u043d\u043e\u0435 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435", (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
        XHelper.writeObject((Element)elm, (String)"config", (Object)this.configuration);
        XHelper.writeBoolean((Element)elm, (String)"firstPhaseCompleted", (boolean)this.firstPhaseCompleted);
    }

    public void fromXML(Element elm) throws Exception {
        this.configuration = (ResendDataToXreportsTaskConfiguration)XHelper.readObject((Element)elm, (String)"config");
        this.firstPhaseCompleted = XHelper.readBoolean((Element)elm, (String)"firstPhaseCompleted", (boolean)false);
    }

    public void stop() throws Exception {
        super.stop();
        if (this.delegate != null) {
            this.delegate.stop();
        }
    }

    static class CreateMarkerObjectsTask
    extends BaseQueryObjectsTask<ResendDataToXreportsTaskConfiguration> {
        private ResendDataToXreportsTaskConfiguration configuration;

        CreateMarkerObjectsTask(ResendDataToXreportsTaskConfiguration configuration) {
            this.configuration = configuration;
        }

        protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
            int totalCount = this.count(this.createCallback(0, this.configuration), BookingFileIndex.class);
            this.processObjects(BookingFileIndex.class.getName(), callback, this.createCallback(totalCount, this.configuration));
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043c\u0430\u0440\u043a\u0435\u0440\u043d\u044b\u0445 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432", (Object[])new Object[0]));
            callback.taskFinished();
        }

        public L10nMessage getDescription() {
            return null;
        }

        private BaseQueryObjectsTask.ProcessCallback createCallback(final int count, final ResendDataToXreportsTaskConfiguration config) {
            return new BaseQueryObjectsTask.ProcessCallback(){
                private static final String UID_ALLIAS = "uidAllias";

                public int getThreadsCount() {
                    return 1;
                }

                public int getTotalCount() {
                    return count;
                }

                public void processObject(Class<?> objectClass, Map<String, String> obj) throws Exception {
                    String uid = obj.get(UID_ALLIAS);
                    XreportsBookingMarkerObject marker = new XreportsBookingMarkerObject();
                    marker.setDeleted(false);
                    marker.setBookingUid(uid);
                    marker.setModified(new Date());
                    AssetsStorage.get().save((BaseAsset)marker);
                }

                public String getUid(Map<String, String> obj) {
                    return obj.get(UID_ALLIAS);
                }

                public Collection<? extends Projection> getProjections(Class<?> cls) {
                    return Collections.singletonList(Projection.property((String)"containerUid", (String)UID_ALLIAS));
                }

                public String getThreadPrefix() {
                    return "create-marker-objects";
                }

                public List<SearchCriterion> getCriterions(Class<?> cls) {
                    ArrayList<SearchCriterion> criteria = new ArrayList<SearchCriterion>();
                    if (config.getFromDate() != null) {
                        criteria.add(SearchCriterion.ge((String)"modified", (Object)config.getFromDate()));
                    }
                    if (config.getToDate() != null) {
                        criteria.add(SearchCriterion.le((String)"modified", (Object)config.getToDate()));
                    }
                    if (config.getBookingNumber() != null) {
                        criteria.add(SearchCriterion.eq((String)BookingFileIndex.Property.fullNumber.name(), (Object)config.getBookingNumber()));
                    }
                    if (config.getProductNumber() != null) {
                        criteria.add(SearchCriterion.contains((String)BookingFileIndex.Property.ticketNumbers.name(), (Object)config.getProductNumber()));
                    }
                    if (!config.getHoldings().isEmpty()) {
                        criteria.add(SearchQueryHelper.buildOrEqStringCriterion((String)BookingFileIndex.Property.holding.name(), (Collection)config.getHoldings().stream().map(EntityReference::getUid).collect(Collectors.toList())));
                    }
                    if (!config.getClients().isEmpty()) {
                        criteria.add(SearchQueryHelper.buildOrEqStringCriterion((String)BookingFileIndex.Property.client.name(), (Collection)config.getClients().stream().map(EntityReference::getUid).collect(Collectors.toList())));
                    }
                    if (!config.getSubagencies().isEmpty()) {
                        criteria.add(SearchQueryHelper.buildOrContainsStringCriterion((String)BookingFileIndex.Property.subagencies.name(), (Collection)config.getSubagencies().stream().map(EntityReference::getUid).collect(Collectors.toList())));
                    }
                    if (!config.getGdsNames().isEmpty()) {
                        criteria.add(SearchQueryHelper.buildOrContainsEnumCriterion((String)BookingFileIndex.Property.gdsNames.name(), (Collection)config.getGdsNames()));
                    }
                    if (!config.getProductTypes().isEmpty()) {
                        criteria.add(SearchQueryHelper.buildOrContainsEnumCriterion((String)BookingFileIndex.Property.ticketTypes.name(), (Collection)config.getProductTypes()));
                    }
                    if (!config.getTravelSubjects().isEmpty()) {
                        criteria.add(SearchQueryHelper.buildOrContainsEnumCriterion((String)BookingFileIndex.Property.travelSubject.name(), (Collection)config.getTravelSubjects()));
                    }
                    return criteria;
                }
            };
        }
    }
}

