/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.tasks;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.ModelContractIndex;
import com.gridnine.xtrip.common.model.profile.RulesHolderIndex;
import com.gridnine.xtrip.common.model.profile.TripartiteContractIndex;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.StorageHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class RuleRestrictionReservationTypesMigrationTask
extends BaseLongRunningTask<Serializable> {
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"\u043c\u0438\u0433\u0440\u0430\u0446\u0438\u044f \u0443\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0438\u0445 \u0442\u0438\u043f\u043e\u0432 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0432 \u043f\u0440\u0430\u0432\u0438\u043b\u0430\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void toXML(Element elm) throws Exception {
    }

    public void configure(Serializable value) throws Exception {
    }

    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(ContractIndex.class);
        classes.add(ModelContractIndex.class);
        classes.add(TripartiteContractIndex.class);
        classes.add(RulesHolderIndex.class);
        for (Class cls : classes) {
            this.migrate(callback, cls);
            if (!this.isToBeStopped()) continue;
            this.log.debug("task is interrupted");
            return;
        }
        callback.taskFinished();
    }

    private <E extends BaseEntity, I extends EntityIndex<E>> void migrate(LongRunningTask.EventsCallback callback, Class<I> cls) {
        for (EntityReference ctrRef : StorageHelper.getEntityReferences((SearchQuery)new SearchQuery(), cls)) {
            if (this.isToBeStopped()) {
                return;
            }
            this.log.debug("updating contract " + ctrRef);
            try {
                EntityContainer ctr = EntityStorage.get().resolve(ctrRef);
                RuleSet ruleSet = (RuleSet)ctr.getEntity().getValue("ruleSet");
                if (ruleSet == null) {
                    this.log.debug("contract " + ctrRef + " has no rules");
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0434\u043e\u0433\u043e\u0432\u043e\u0440 {0} \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043f\u0440\u0430\u0432\u0438\u043b", (Object[])new Object[]{ctrRef}));
                    continue;
                }
                AtomicBoolean changed = new AtomicBoolean(false);
                for (RuleSettings rs : ruleSet.getRules()) {
                    List<RuleRestriction> restrictions = rs.getRestrictions().stream().filter(restr -> restr.getProperty() == Properties.RESERVATION_TYPE).collect(Collectors.toList());
                    restrictions.forEach(restr -> {
                        List resTypes = (List)restr.getValue();
                        if (resTypes.contains(ReservationType.CALL_CENTER) || resTypes.contains(ReservationType.INTERNET)) {
                            resTypes.replaceAll(resType -> {
                                if (resType == ReservationType.CALL_CENTER) {
                                    return ReservationType.OFFLINE;
                                }
                                if (resType == ReservationType.INTERNET) {
                                    return ReservationType.IBE;
                                }
                                return resType;
                            });
                            changed.set(true);
                        }
                    });
                }
                if (!changed.get()) {
                    this.log.debug("contract " + ctrRef + " has no deprecated rule restriction reservation types");
                    continue;
                }
                ctr.getVersionInfo().setDataSource("server-task");
                ctr.getVersionInfo().setVersionNotes("modified by task " + ((Object)((Object)this)).getClass().getSimpleName());
                LogicalStorage.get().getEntityStorage().save(ctr, true);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440 {0}", (Object[])new Object[]{ctrRef}));
            }
            catch (Throwable e) {
                this.log.error("unable to update contract " + ctrRef, e);
                callback.addEvent(null, MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440 {0}", (Throwable)e, (Object[])new Object[]{ctrRef}));
            }
        }
    }

    public boolean isIndefinite() {
        return true;
    }
}

