/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.tasks;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.AviaDuplicatesCheckParameters;
import com.gridnine.xtrip.common.model.ibecorp.sm.BaseDuplicatesCheckParameters;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMBookingControlSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteIndex;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.duplicates.DupesMessageHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SMBookingControlSettingsCreateTask
extends BaseLongRunningTask<Serializable> {
    private final Logger logger = LoggerFactory.getLogger(SMBookingControlSettingsCreateTask.class);

    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.logger.debug("Start executing SMBookingControlSettingsCreateTask");
        EntityStorage storage = EntityStorage.get();
        EntityStorage.get().search(SMSiteIndex.class, new SearchQuery()).getData().stream().filter(item -> !"default_site_uid".equals(item.getSource().getUid())).forEach(index -> {
            EntityReference siteRef = index.getSource();
            try {
                this.logger.info(String.format("creation SMBookingControlSettings for site %s", siteRef.getCaption()));
                SMBookingControlSettings settings = this.createSMBookingControlSettings((EntityReference<SMSite>)siteRef);
                EntityContainer settingsCtr = EntityStorageHelper.createContainer((BaseEntity)settings, (EntityStorageContext)new EntityStorageContext());
                settingsCtr.getVersionInfo().setDataSource("SMBookingControlSettingsCreateTask");
                storage.save(settingsCtr, true);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)String.format("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0439 (%s) \u0441\u043e\u0437\u0434\u0430\u043d\u044b \u0434\u043b\u044f \u0441\u0430\u0439\u0442\u0430 %s", settingsCtr.getUid(), siteRef.getCaption()), (Object[])new Object[0]));
            }
            catch (Exception e) {
                this.logger.error(String.format("failed creating SMBookingControlSettings for site %s", siteRef.getCaption()));
            }
        });
        callback.taskFinished();
        this.logger.debug("Finish executing SMBookingControlSettingsCreateTask");
    }

    public void toXML(Element elm) throws Exception {
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void configure(Serializable configuration) throws Exception {
    }

    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.SMBookingControlSettingsCreateTask, (Object[])new Object[0]);
    }

    private SMBookingControlSettings createSMBookingControlSettings(EntityReference<SMSite> siteRef) {
        SMBookingControlSettings settings = new SMBookingControlSettings();
        settings.setSite(siteRef);
        AviaDuplicatesCheckParameters aviaParams = new AviaDuplicatesCheckParameters();
        DupesMessageHelper.fillDefaultDuplicatesCheckParameters((BaseDuplicatesCheckParameters)aviaParams, ProductType.AIR_TICKET);
        settings.getDuplicatesCheckParameters().add(aviaParams);
        for (ProductType productTyp : Arrays.asList(ProductType.HOTEL_RESERVATION, ProductType.RAILWAY_PRODUCT, ProductType.TRANSFER)) {
            BaseDuplicatesCheckParameters parameters = new BaseDuplicatesCheckParameters();
            DupesMessageHelper.fillDefaultDuplicatesCheckParameters(parameters, productTyp);
            settings.getDuplicatesCheckParameters().add(parameters);
        }
        return settings;
    }
}

