/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.tasks;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.ibecorp.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.BaseSMProfile;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMAccessSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMProfileType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteIndex;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.common.StorageHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.List;
import org.w3c.dom.Element;

public class SMSettingsToSiteMoveDomainTask
extends BaseLongRunningTask<Serializable> {
    public void configure(Serializable configuration) throws Exception {
    }

    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"\u041f\u0435\u0440\u0435\u043d\u043e\u0441 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e \u043f\u043e\u043b\u044e \"\u0414\u043e\u043c\u0435\u043d\" \u0438\u0437 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0434\u043e\u0441\u0442\u0443\u043f\u0430\" \u0432 \"\u0421\u0430\u0439\u0442\"", (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
    }

    public void fromXML(Element elm) throws Exception {
    }

    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("moving domain field from SMAccessSettingsToSite started");
        if (this.isToBeStopped()) {
            this.log.debug("task is interupted");
            return;
        }
        try {
            int n = 0;
            List siteReferences = StorageHelper.getEntityReferences((SearchQuery)new SearchQuery(), SMSiteIndex.class);
            for (EntityReference siteRef : siteReferences) {
                if (this.isToBeStopped()) {
                    this.log.debug(String.format("Task is interupted while migrating domain data for site [%s]", siteRef));
                    return;
                }
                byte progress = (byte)(100 * ++n / siteReferences.size());
                if (n % 5 == 0) {
                    callback.updateProgress(progress);
                }
                this.log.debug(String.format("Processing [%s] site %s of %s (%s%%)", siteRef, String.valueOf(n), String.valueOf(siteReferences.size()), String.valueOf(progress)));
                EntityContainer siteCont = EntityStorage.get().resolve(siteRef);
                if (siteCont != null && siteCont.getEntity() != null) {
                    SMSite site = (SMSite)siteCont.getEntity();
                    EntityContainer accessSettingsCont = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(SMSettingsToSiteMoveDomainTask.getAccessSettingsReference((EntityReference<SMSite>)siteRef));
                    if (accessSettingsCont != null && accessSettingsCont.getEntity() != null && !TextUtil.isBlank((String)((SMAccessSettings)accessSettingsCont.getEntity()).getDomain())) {
                        site.setDomain(((SMAccessSettings)accessSettingsCont.getEntity()).getDomain());
                        EntityStorage.get().save(siteCont, true);
                        continue;
                    }
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0414\u043b\u044f \u0441\u0430\u0439\u0442\u0430 {0} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0434\u043e\u0441\u0442\u0443\u043f\u0430", (Object[])new Object[]{siteRef.toString()}));
                    this.log.warn(String.format("Site %s has no access settings", siteRef));
                    continue;
                }
                this.log.debug(String.format("Site [%s] is not resolved", siteRef.toString()));
            }
        }
        catch (Exception e) {
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e\u043b\u044f \"\u0414\u043e\u043c\u0435\u043d\" \u0438\u0437 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0434\u043e\u0441\u0442\u0443\u043f\u0430\" \u0432 \"\u0421\u0430\u0439\u0442\"", (Object[])new Object[0]));
            this.log.error(String.format("Error occured during domain data migration", new Object[0]), (Throwable)e);
        }
        callback.taskFinished();
        this.log.debug("Moving domain data from SMAccessSettings to SMSite is finished");
    }

    private static EntityReference<? extends BaseSMProfile> getAccessSettingsReference(EntityReference<SMSite> siteRef) {
        EntityReference ref = ProfileHelper.getProfile(siteRef, (SMProfileType)SMProfileType.ACCESS_SETTINGS);
        return ref;
    }
}

