/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.tasks;

import com.gridnine.xtrip.common.ibecorp.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.BaseSMProfile;
import com.gridnine.xtrip.common.model.ibecorp.sm.BaseSMProfileIndex;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.storage.common.StorageHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;

public class SMSitesAddTask
extends BaseLongRunningTask<Serializable> {
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 B2C \u0441\u0430\u0439\u0442\u043e\u0432", (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void toXML(Element elm) throws Exception {
    }

    public void configure(Serializable value) throws Exception {
    }

    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("sites add started");
        if (this.isToBeStopped()) {
            this.log.debug("task is interupted");
            return;
        }
        try {
            int n = 0;
            HashMap<EntityReference, EntityContainer> siteContainers = new HashMap<EntityReference, EntityContainer>();
            List profileReferences = StorageHelper.getEntityReferences((SearchQuery)new SearchQuery(), BaseSMProfileIndex.class);
            for (EntityReference profileReference : profileReferences) {
                if (this.isToBeStopped()) {
                    this.log.debug(String.format("Task is interupted while adding SMSites to profile [%s]", profileReference));
                    return;
                }
                byte progress = (byte)(100 * ++n / profileReferences.size());
                if (n % 5 == 0) {
                    callback.updateProgress(progress);
                }
                this.log.debug(String.format("Processing profile [%s] %s of %s (%s%%)", profileReference, String.valueOf(n), String.valueOf(profileReferences.size()), String.valueOf(progress)));
                EntityContainer profileContainer = EntityStorage.get().resolve(profileReference);
                if (profileContainer != null) {
                    BaseSMProfile profile = (BaseSMProfile)profileContainer.getEntity();
                    EntityContainer agencyContainer = EntityStorage.get().resolve(profile.getAgency());
                    if (agencyContainer != null) {
                        EntityContainer siteContainer = (EntityContainer)siteContainers.get(agencyContainer.toReference());
                        if (siteContainer == null) {
                            siteContainer = EntityStorage.get().resolve(ProfileHelper.findB2cSite((EntityReference)agencyContainer.toReference()));
                        }
                        if (siteContainer == null) {
                            SMSite site = new SMSite();
                            site.setName(String.format("\u0421\u0430\u0439\u0442 %s", agencyContainer.toReference()));
                            site.setSiteType(SMSiteType.B2C);
                            siteContainer = EntityContainer.create((BaseEntity)site);
                            siteContainers.put(agencyContainer.toReference(), siteContainer);
                            Organization agency = (Organization)agencyContainer.getEntity();
                            agency.setB2cSite(siteContainer.toReference());
                            EntityStorage.get().save(agencyContainer, true);
                        }
                        profile.setSite(siteContainer.toReference());
                    } else {
                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0412 \u043f\u0440\u043e\u0444\u0438\u043b\u0435 {0} \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e", (Object[])new Object[]{profileReference}));
                        this.log.warn(String.format("Profile %s has no agency", profileReference));
                    }
                    profileContainer.getVersionInfo().setDataSource("sites-add-task");
                    profileContainer.getVersionInfo().setVersionNotes("modified by task " + ((Object)((Object)this)).getClass().getSimpleName());
                    EntityStorage.get().save(profileContainer, true);
                    continue;
                }
                this.log.debug(String.format("Profile [%s] is not resolved", profileReference.toString()));
            }
            for (EntityContainer siteContaner : siteContainers.values()) {
                EntityStorage.get().save(siteContaner, true);
            }
        }
        catch (Exception e) {
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0438 \u0441\u0430\u0439\u0442\u043e\u0432", (Object[])new Object[0]));
            this.log.error(String.format("Error occured during sites add", new Object[0]), (Throwable)e);
        }
        callback.taskFinished();
        this.log.debug("Sites add is finished");
    }
}

