/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.tasks;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.sm.BaseSMProfileIndex;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMProfileType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep2Settings;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SMStep2SettingsUpdateTask2
extends BaseLongRunningTask<Serializable> {
    private final Logger logger = LoggerFactory.getLogger(SMStep2SettingsUpdateTask2.class);

    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.logger.debug("Start executing SMStep2SettingsUpdateTask2");
        EntityStorage storage = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BaseSMProfileIndex.Property.profileType.name(), (Object)SMProfileType.STEP2_SETTINGS));
        List indices = storage.search(BaseSMProfileIndex.class, query).getData();
        indices.forEach(i -> {
            try {
                this.logger.info(String.format("executing updating settings for site %s", i.getSite().getCaption()));
                EntityContainer settings = storage.resolve(i.getSource());
                if (settings != null && settings.getEntity() instanceof SMStep2Settings) {
                    ((SMStep2Settings)settings.getEntity()).setFilterHotelMeal(true);
                    ((SMStep2Settings)settings.getEntity()).setFilterHotelRefundable(true);
                    ((SMStep2Settings)settings.getEntity()).setFilterHotelAvailability(true);
                    ((SMStep2Settings)settings.getEntity()).setFilterHotelTripartiteContract(true);
                    settings.getVersionInfo().setDataSource("SMStep2SettingsUpdateTask2");
                    storage.save(settings, true);
                }
            }
            catch (Exception e) {
                this.logger.error(String.format("failed updating settings for site %s", i.getSite().getCaption()));
            }
        });
        callback.taskFinished();
        this.logger.debug("Finish executing SMStep2SettingsUpdateTask2");
    }

    public void toXML(Element elm) throws Exception {
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void configure(Serializable configuration) throws Exception {
    }

    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.SMStep2SettingsUpdateTask2, (Object[])new Object[0]);
    }
}

