/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.tasks;

import com.gridnine.xtrip.common.ibecorp.l10n.Messages;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.CorrespondenceDelaySettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.MailTemplate;
import com.gridnine.xtrip.common.model.mail.MailAddress;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.mail.MailServerParameters;
import com.gridnine.xtrip.common.model.mail.MailServerSettings;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationBalanceIndex;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibecorp.notifications.BalanceNotification;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.model.mail.MailConfigUtil;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.w3c.dom.Element;

public class SendBalanceNotificationsTask
extends BaseLongRunningTask<Serializable> {
    public void toXML(Element elm) throws Exception {
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void configure(Serializable configuration) throws Exception {
    }

    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.SendBalanceNotificationsTask, (Object[])new Object[0]);
    }

    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        if (this.isToBeStopped()) {
            this.log.debug("task interrupted");
            return;
        }
        EntityStorage storage = EntityStorage.get();
        long delayCurrent = 0L;
        CorrespondenceDelaySettings delaySettings = (CorrespondenceDelaySettings)CollectionUtil.singleOrNull((Collection)SystemHelper.searchSystemSettings(CorrespondenceDelaySettings.class));
        long delayDelta = 1000L * (long)Optional.ofNullable(delaySettings).map(CorrespondenceDelaySettings::getDelayInSeconds).orElse(0).intValue();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)OrganizationBalanceIndex.Property.client.name(), null));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)OrganizationBalanceIndex.Property.agency.name(), null));
        List indices = storage.search(OrganizationBalanceIndex.class, query).getData();
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041d\u0430\u0439\u0434\u0435\u043d\u043e {0} \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u0411\u0430\u043b\u0430\u043d\u0441 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438", (Object[])new Object[]{indices.size()}));
        if (indices.size() == 0) {
            callback.taskFinished();
            return;
        }
        boolean wasStopped = false;
        int total = indices.size();
        int current = 0;
        int sent = 0;
        byte progress = 0;
        for (OrganizationBalanceIndex index : indices) {
            if (this.isToBeStopped()) {
                this.log.debug("task interrupted");
                wasStopped = true;
                break;
            }
            EntityReference agency = index.getAgency();
            EntityReference client = index.getClient();
            if (!Organization.class.equals((Object)agency.getType()) || !Organization.class.equals((Object)client.getType())) continue;
            try {
                byte newProgress;
                BalanceNotification notification = new BalanceNotification(index, (EntityReference<Organization>)client, (EntityReference<Organization>)agency);
                MailTemplate template = notification.getTemplate();
                if (template != null) {
                    MailServerSettings mailServerSettings = MailConfigUtil.readMailServerParameters();
                    MailServerParameters mailServerParameters = mailServerSettings.getMailServerParameters();
                    MailAddress mailFrom = new MailAddress();
                    mailFrom.setAddress(mailServerSettings.getDefaultFrom());
                    MailDocument mailDocument = NotificationHelper.buildMailDocument(notification, false, mailFrom);
                    NotificationHelper.sendMail(mailServerParameters, mailDocument, true, delayCurrent);
                    delayCurrent += delayDelta;
                    ++sent;
                }
                if (progress == (newProgress = (byte)(++current * 100 / total))) continue;
                progress = newProgress;
                callback.updateProgress(progress);
            }
            catch (Exception e) {
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u043e \u0431\u0430\u043b\u0430\u043d\u0441\u0435 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 {0}", (Object[])new Object[]{index.getClient()}));
                this.log.error(String.format("failed send balance notification for client %s", index.getClient()), (Throwable)e);
            }
        }
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e {0} \u043e\u043f\u043e\u0432\u0435\u0449\u0435\u043d\u0438\u0439 \u043e \u0431\u0430\u043b\u0430\u043d\u0441\u0435 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438", (Object[])new Object[]{sent}));
        if (!wasStopped) {
            callback.taskFinished();
        }
    }
}

