/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.tasks;

import com.gridnine.xtrip.common.ibecorp.l10n.Messages;
import com.gridnine.xtrip.common.ibecorp.model.UdidValueDeletionTaskConfiguration;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.profile.PersonEmploymentIndex;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.util.List;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class UdidValueDeletionTask
extends BaseLongRunningTask<UdidValueDeletionTaskConfiguration> {
    private UdidValueDeletionTaskConfiguration config;
    private int count = 0;

    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("UDID value deletion task started");
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonEmploymentIndex.Property.organization.name(), (Object)this.config.getOrganization()));
        List employeesRef = EntityStorage.get().search(PersonEmploymentIndex.class, query).getData().stream().map(PersonEmploymentIndex::getSource).collect(Collectors.toList());
        int total = employeesRef.size();
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432\u0441\u0435\u0433\u043e {0} \u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u043e\u0432", (Object[])new Object[]{total}));
        int current = 0;
        byte progress = 0;
        for (EntityReference ref : employeesRef) {
            byte newProgress;
            if (this.isToBeStopped()) {
                this.log.debug("UDID value deletion task is interrupted");
                return;
            }
            Person person = (Person)EntityStorage.get().resolve(ref).getEntity();
            if (person.getCostCodes().stream().anyMatch(this::equalsCategory)) {
                LockUtil.lock((EntityReference)ref, ctr -> {
                    boolean removed = ((Person)ctr.getEntity()).getCostCodes().removeIf(this::equalsCategory);
                    if (removed) {
                        ctr.getVersionInfo().setDataSource("udid value deletion task");
                        EntityStorage.get().save(ctr, true);
                        ++this.count;
                    }
                });
            }
            if (progress == (newProgress = (byte)(++current * 100 / total))) continue;
            progress = newProgress;
            callback.updateProgress(progress);
        }
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 UDID \u0443\u0434\u0430\u043b\u0435\u043d\u044b \u0443 {0} \u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u043e\u0432", (Object[])new Object[]{this.count}));
        callback.taskFinished();
        this.log.debug("UDID value deletion task finished");
    }

    private boolean equalsCategory(PersonCostCode costCode) {
        return costCode.getCostCodeProperties() != null && MiscUtil.equals((Object)this.config.getOrganization(), (Object)costCode.getOrganization()) && MiscUtil.equals((Object)this.config.getCategory(), (Object)costCode.getCostCodeProperties().getCategory());
    }

    public void configure(UdidValueDeletionTaskConfiguration configuration) throws Exception {
        this.config = configuration;
    }

    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.UdidValueDeletionTask, (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
        XHelper.writeObject((Element)elm, (String)"config", (Object)this.config);
        Element countElement = XmlUtil.addElement((Element)elm, (String)"count");
        countElement.setAttribute("value", String.valueOf(this.count));
    }

    public void fromXML(Element elm) throws Exception {
        this.config = (UdidValueDeletionTaskConfiguration)XHelper.readObject((Element)elm, (String)"config");
        Element countElement = XmlUtil.getElement((Element)elm, (String)"count");
        if (countElement != null) {
            this.count = Integer.parseInt(countElement.getAttribute("value"));
        }
    }
}

