/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.tasks;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ExternalSystem;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.ExternalSystemCodeV2;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.Objects;
import org.w3c.dom.Element;

public class UpdateBookingExternalSystemCodeTask
extends BaseLongRunningTask<Serializable> {
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        EntityStorage storage = EntityStorage.get();
        storage.search(BookingFileIndex.class, new SearchQuery()).getData().stream().map(idx -> storage.resolve(idx.getSource())).filter(Objects::nonNull).filter(bf -> ((BookingFile)bf.getEntity()).getExternalCode() != null).forEach(bf -> {
            try {
                ExternalSystemCodeV2 externalSystem = new ExternalSystemCodeV2();
                externalSystem.setSystem((DictionaryReference)((ExternalSystem)DictionaryCache.get().findByCode(ExternalSystem.class, ((BookingFile)bf.getEntity()).getExternalCode().getSystem().name())).toReference());
                externalSystem.setCode(((BookingFile)bf.getEntity()).getExternalCode().getCode());
                ((BookingFile)bf.getEntity()).getExternalCodes().add(externalSystem);
                storage.save(bf, false);
            }
            catch (Exception e) {
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)("\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0437\u0430\u043a\u0430\u0437\u0430 \u2116" + ((BookingFile)bf.getEntity()).getNumber()), (Object[])new Object[0]));
                this.log.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0437\u0430\u043a\u0430\u0437 \u2116" + ((BookingFile)bf.getEntity()).getNumber(), (Throwable)e);
            }
        });
        callback.taskFinished();
    }

    public void configure(Serializable configuration) throws Exception {
    }

    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"\u041f\u0435\u0440\u0435\u043d\u043e\u0441 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0437 \u043f\u043e\u043b\u044f \"externalCode\" \u0432 \u043f\u043e\u043b\u0435 \"externalCodes\"", (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
    }

    public void fromXML(Element elm) throws Exception {
    }
}

