/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.tasks;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.WorkflowStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.List;
import org.w3c.dom.Element;

public class UpdateIncomeForCancelledBookings
extends BaseLongRunningTask<Serializable> {
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0434\u043e\u0445\u043e\u0434\u0430 \u0443 \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043d\u044b\u0445 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0439!", (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void toXML(Element elm) throws Exception {
    }

    public void configure(Serializable value) throws Exception {
    }

    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        if (this.isToBeStopped()) {
            this.log.debug("task is interupted");
            return;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BookingFileIndex.Property.workflowStatus.name(), (Object)WorkflowStatus.CANCELED), SearchCriterion.eq((String)BookingFileIndex.Property.workflowStatus.name(), (Object)WorkflowStatus.ERROR), SearchCriterion.contains((String)BookingFileIndex.Property.reservationStatuses.name(), (Object)ReservationStatus.CANCELED), SearchCriterion.contains((String)BookingFileIndex.Property.reservationStatuses.name(), (Object)ReservationStatus.ERROR)}));
        EntityStorage storage = EntityStorage.get();
        List productIndexes = storage.search(BookingFileIndex.class, query).getData();
        for (BookingFileIndex bfIndex : productIndexes) {
            if (this.isToBeStopped()) {
                this.log.debug("task is interupted");
                return;
            }
            EntityContainer bfCtr = storage.resolve(bfIndex.getSource());
            List recordLocators = SearchQueryHelper.getRecordLocatorsFromIndexRecords((List)bfIndex.getRecordLocators());
            if (recordLocators.isEmpty()) {
                recordLocators = bfIndex.getPnr();
            }
            this.log.debug(String.format("updating undex [%s]", recordLocators));
            try {
                storage.save(bfCtr, false);
            }
            catch (Throwable e) {
                this.log.error("unable to update index [%s]" + recordLocators, e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c ,\u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 {0}", (Throwable)e, (Object[])new Object[]{bfIndex}));
            }
        }
        callback.taskFinished();
    }

    public boolean isIndefinite() {
        return true;
    }
}

