/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ufs.response;

import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.ibecorp.ufs.model.TransInfoResponse;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.BlankInfo;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.BlankPassenger;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.CarriageType;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.DocType;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.DocumentInfo;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.OperationTrainInfo;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.PassengerType;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.RouteInfoExt;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.SeatType;
import com.gridnine.xtrip.server.ibecorp.ufs.response.AbstractResponseParser;
import com.gridnine.xtrip.server.ibecorp.ufs.response.Util;
import java.text.SimpleDateFormat;
import org.w3c.dom.Element;

public class TransInfoResponseParser
extends AbstractResponseParser<TransInfoResponse> {
    private final SimpleDateFormat dformat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    public TransInfoResponseParser(Element root) {
        super(root);
    }

    @Override
    public TransInfoResponse toModel() throws Exception {
        TransInfoResponse response = new TransInfoResponse();
        if (!this.validate(this.root, response)) {
            return response;
        }
        response.setTransInfo(Util.createTransInfo(this.root));
        response.setTrainInfo(this.createTrainInfo(this.root));
        response.setTerminal(XHelper.readString((Element)this.root, (String)"Terminal"));
        response.setTest("1".equals(XHelper.readString((Element)this.root, (String)"IsTest")));
        for (Element el : XmlUtil.getElements((Element)this.root, (String)"Blank")) {
            response.getBlanks().add(this.createBlankInfo(el));
        }
        for (Element el : XmlUtil.getElements((Element)this.root, (String)"Passenger")) {
            response.getPassangers().add(this.createPassenger(el));
        }
        return response;
    }

    private OperationTrainInfo createTrainInfo(Element el) throws Exception {
        if (el == null) {
            return null;
        }
        OperationTrainInfo result = new OperationTrainInfo();
        RouteInfoExt routeInfo = new RouteInfoExt();
        Element stationEl = XmlUtil.getElement((Element)el, (String)"StationFrom");
        if (stationEl != null) {
            routeInfo.setDeparture(stationEl.getTextContent());
            routeInfo.setDepartureCode(stationEl.getAttribute("Code"));
        }
        if ((stationEl = XmlUtil.getElement((Element)el, (String)"StationTo")) != null) {
            routeInfo.setArrival(stationEl.getTextContent());
            routeInfo.setArrivalCode(stationEl.getAttribute("Code"));
        }
        result.setRouteInfo(routeInfo);
        result.setDepartureDatetime(this.dformat.parse(XHelper.readString((Element)el, (String)"DepartTime")));
        result.setArrivalDatetime(this.dformat.parse(XHelper.readString((Element)el, (String)"ArrivalTime")));
        result.setTrainNumber(XHelper.readString((Element)el, (String)"TrainNum"));
        result.setCarNumber(XHelper.readString((Element)el, (String)"CarNum"));
        String carTypeStr = XHelper.readString((Element)el, (String)"CarType");
        result.setCarriageTypeStr(carTypeStr);
        result.setCarriageType(CarriageType.getByValue(carTypeStr));
        String seatTypeStr = XHelper.readString((Element)el, (String)"GenderClass");
        result.setSeatTypeStr(seatTypeStr);
        result.setSeatType(SeatType.getByValue(seatTypeStr));
        result.setCarOwner(XHelper.readString((Element)el, (String)"Carrier"));
        return result;
    }

    private BlankInfo createBlankInfo(Element el) throws Exception {
        BlankInfo result = new BlankInfo();
        result.setBlankId(el.getAttribute("ID"));
        result.setPrevID(el.getAttribute("PrevID"));
        result.setRefund("1".equals(XHelper.readString((Element)el, (String)"RetFlag")));
        result.setAmount(XHelper.readBigDecimal((Element)el, (String)"Amount"));
        result.setAmountNDS(XHelper.readBigDecimal((Element)el, (String)"AmountNDS"));
        result.setTariffReturnNds(XHelper.readBigDecimal((Element)el, (String)"TariffReturnNds"));
        result.setServiceReturnNds(XHelper.readBigDecimal((Element)el, (String)"ServiceReturnNds"));
        result.setReclamationCollectReturnNds(XHelper.readBigDecimal((Element)el, (String)"ReclamationCollectReturnNds"));
        result.setTariffRateNds(XHelper.readDouble((Element)el, (String)"TariffRateNds", (double)0.0));
        result.setServiceRateNds(XHelper.readDouble((Element)el, (String)"ServiceRateNds", (double)0.0));
        result.setReclamationCollectRateNds(XHelper.readDouble((Element)el, (String)"ReclamationCollectRateNds", (double)0.0));
        result.setTicketNumber(XHelper.readString((Element)el, (String)"TicketNum"));
        result.setHasEReg("1".equals(XHelper.readString((Element)el, (String)"RemoteCheckIn")));
        result.setWasPrint("1".equals(XHelper.readString((Element)el, (String)"PrintFlag")));
        result.setRzdStatus(Util.convertRzdStatusFromGds(XHelper.readInt((Element)el, (String)"RzhdStatus")));
        return result;
    }

    private BlankPassenger createPassenger(Element el) {
        BlankPassenger result = new BlankPassenger();
        result.setId(Integer.valueOf(el.getAttribute("ID")));
        result.setBlankID(el.getAttribute("BlankID"));
        String passTypeStr = XHelper.readString((Element)el, (String)"Type");
        result.setPassTypeStr(passTypeStr);
        result.setPassType(PassengerType.getByValue(passTypeStr));
        DocType docType = DocType.getByValue(XHelper.readString((Element)el, (String)"DocType"));
        String docNumber = XHelper.readString((Element)el, (String)"DocNum");
        result.setDocInfo(new DocumentInfo(docType, docNumber));
        String fio = XHelper.readString((Element)el, (String)"Name");
        String[] names = fio.split(" ");
        Util.setFioToPassenger(names, result);
        result.setPlace(XHelper.readString((Element)el, (String)"Place"));
        return result;
    }
}

