/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ufs.response;

import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdStatus;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.Carriage;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.CarriageType;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.RouteInfo;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.TicketPassenger;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.TransInfo;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.TransactionType;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.w3c.dom.Element;

public class Util {
    private static Map<Integer, RzdStatus> rzdStatusMap = new HashMap<Integer, RzdStatus>();

    public static RzdStatus convertRzdStatusFromGds(Integer rzdStatusCode) {
        return rzdStatusMap.get(rzdStatusCode);
    }

    public static RouteInfo readRouteInfo(Element parent, String path) {
        Element el = XmlUtil.getElement((Element)parent, (String)path);
        if (el == null) {
            return null;
        }
        RouteInfo routeInfo = new RouteInfo();
        Util.fillRouteInfo(parent, path, routeInfo);
        return routeInfo;
    }

    static void fillRouteInfo(Element parent, String path, RouteInfo routeInfo) {
        Element el = XmlUtil.getElement((Element)parent, (String)path);
        if (el == null) {
            return;
        }
        Element[] els = XmlUtil.getElements((Element)el, (String)"C");
        if (els.length > 0) {
            routeInfo.setDeparture(els[0].getTextContent());
            if (els.length > 1) {
                routeInfo.setArrival(els[1].getTextContent());
            }
        }
    }

    public static void fillCarriage(Element el, Carriage carriage) {
        String carriageTypeStr = XHelper.readString((Element)el, (String)"KV");
        carriage.setCarriageTypeStr(carriageTypeStr);
        carriage.setCarriageType(CarriageType.getByValue(carriageTypeStr));
        carriage.setUndefinedCount(XHelper.readInt((Element)el, (String)"M4"));
        carriage.setLowerCount(XHelper.readInt((Element)el, (String)"M5"));
        carriage.setUpperCount(XHelper.readInt((Element)el, (String)"M6"));
        carriage.setLowerSideCount(XHelper.readInt((Element)el, (String)"M7"));
        carriage.setUpperSideCount(XHelper.readInt((Element)el, (String)"M8"));
        carriage.setMaleCount(XHelper.readInt((Element)el, (String)"X1"));
        carriage.setFemaleCount(XHelper.readInt((Element)el, (String)"X2"));
        carriage.setWholeCount(XHelper.readInt((Element)el, (String)"X3"));
        carriage.setMixedCount(XHelper.readInt((Element)el, (String)"X4"));
    }

    static void setFioToPassenger(String[] names, TicketPassenger passenger) {
        if (names.length > 0) {
            passenger.setLastName(names[0]);
            if (names.length > 1) {
                passenger.setFirstName(names[1]);
                if (names.length > 2) {
                    passenger.setMiddleName(names[2]);
                }
            }
        }
    }

    static TransInfo createTransInfo(Element el) throws Exception {
        TransInfo result = new TransInfo();
        result.setIdTrans(XHelper.readString((Element)el, (String)"TransID"));
        result.setPrevTrans(XHelper.readString((Element)el, (String)"PrevTransID"));
        result.setStan(XHelper.readString((Element)el, (String)"STAN"));
        result.settStatus(XHelper.readInt((Element)el, (String)"TStatus"));
        result.setrStatus(XHelper.readInt((Element)el, (String)"RStatus"));
        result.setOrderNum(XHelper.readString((Element)el, (String)"OrderNum"));
        result.setFee(XHelper.readBigDecimal((Element)el, (String)"Fee"));
        Integer type = XHelper.readInt((Element)el, (String)"Type");
        if (type != null) {
            result.setTransactionType(TransactionType.getByValue(type));
        }
        result.setCreateDate(Util.parseDate(el, "CreateTime"));
        result.setConfirmDate(Util.parseDate(el, "ConfirmTime"));
        result.setRefundExpireDate(Util.parseDate(el, "ExpierSetEr"));
        result.setAmount(XHelper.readBigDecimal((Element)el, (String)"Amount"));
        result.setPlaceCount(XHelper.readInt((Element)el, (String)"PlaceCount"));
        result.setTerminal(XHelper.readString((Element)el, (String)"Terminal"));
        result.setTest("1".equals(XHelper.readString((Element)el, (String)"IsTest")));
        return result;
    }

    private static Date parseDate(Element el, String dateTag) throws Exception {
        SimpleDateFormat dformat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        String dateStr = XHelper.readString((Element)el, (String)dateTag);
        if (TextUtil.isBlank((String)dateStr)) {
            return null;
        }
        String timeOffset = XHelper.readString((Element)el, (String)(dateTag + "@timeOffset"));
        if (TextUtil.isBlank((String)timeOffset)) {
            return dformat.parse(dateStr);
        }
        DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"dd.MM.yyyy HH:mm:ssZZ");
        return dtf.parseDateTime(dateStr + timeOffset).toDate();
    }

    static {
        rzdStatusMap.put(0, RzdStatus.NO_ER);
        rzdStatusMap.put(1, RzdStatus.WITH_ER);
        rzdStatusMap.put(2, RzdStatus.NOT_CONFIRMED);
        rzdStatusMap.put(3, RzdStatus.CANCEL);
        rzdStatusMap.put(4, RzdStatus.REFUND);
        rzdStatusMap.put(5, RzdStatus.PLACES_REFUND);
        rzdStatusMap.put(6, RzdStatus.PRINT);
        rzdStatusMap.put(7, RzdStatus.DEFERRED_PAYMENT);
        rzdStatusMap.put(20, RzdStatus.ER_ERROR);
    }
}

