/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.webservice.common.ibus;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.server.ibecorp.webservice.common.ibus.IBusSoapKeys;
import com.gridnine.xtrip.server.ibecorp.webservice.common.tasks.IBusWsProperties;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import java.util.HashMap;
import java.util.Map;

public class IBusWSTask {
    private String routeId;
    private String adapterId;
    private boolean async;
    private final Map<String, Object> data = new HashMap<String, Object>();

    public void configure(IBusWsProperties properties) {
        this.adapterId = properties.getAdapterId();
        this.routeId = properties.getRouteId();
        if (this.adapterId == null && this.routeId == null) {
            throw Xeption.forDeveloper((String)"\u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0437\u0430\u0434\u0430\u0442\u044c \u043e\u0434\u0438\u043d \u0438\u0437 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 'adapterId' \u0438\u043b\u0438 'routeId'", (Object[])new Object[0]);
        }
        this.data.put("adapterId", this.adapterId);
        this.data.put("routeId", this.routeId);
        this.async = properties.isAsync();
    }

    public void processRequest(Object request) {
        this.refreshData();
        this.data.put(IBusSoapKeys.REQUEST_WS.name(), request);
        if (this.async) {
            IntegrationBusFacade.get().sendRouteAsync(this.routeId, this.data);
        } else {
            IntegrationBusFacade.get().processRouteSync(this.routeId, this.data);
        }
    }

    private void refreshData() {
        String adapterId = (String)this.data.get("adapterId");
        String routeId = (String)this.data.get("routeId");
        this.data.clear();
        this.data.put("adapterId", adapterId);
        this.data.put("routeId", routeId);
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public Object getResponse() {
        return this.data.get(IBusSoapKeys.RESPONSE_WS.name());
    }
}

