/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.webservice.common.ibus.auth;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.AuthorizationHelper;
import com.gridnine.xtrip.server.ibecorp.webservice.common.ibus.IBusSoapKeys;
import com.gridnine.xtrip.server.ibecorp.webservice.common.model.AuthContextWS;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class WebServiceBasicAuthentication
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AuthContextWS authContextWS = (AuthContextWS)ctx.getMandatoryObject((Enum)IBusSoapKeys.BASE_AUTHENTICATION_CONTEXT);
        String login = authContextWS.getLogin();
        String password = authContextWS.getPassword();
        try {
            LogicalStorage.get().authorize(login, password.toCharArray());
            EntityContainer<Person> authorizedUser = null;
            try {
                EntityContainer<Person> loggedProfile = AuthorizationHelper.findProfileByLogin(login);
                if (AuthorizationHelper.isValidB2BPersonTypes((Person)loggedProfile.getEntity())) {
                    authorizedUser = loggedProfile;
                }
                ctx.putObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER, (Object)authorizedUser.toReference());
            }
            catch (Exception e) {
                ctx.putObject((Enum)IBusSoapKeys.AUTHENTICATION_FAILED, (Object)"Error logging in user. Cannot find profile.");
                this.log.error(String.format("Error logging in user. Cannot find profile [%s]", login));
                throw e;
            }
        }
        catch (Throwable t) {
            ctx.putObject((Enum)IBusSoapKeys.AUTHENTICATION_FAILED, (Object)"Invalid login or password");
            throw Xeption.forEndUser((String)"Invalid login or password", (Object[])new Object[0]);
        }
    }
}

