/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.webservice.lenta.helpers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.parsers.helpers.PersonParserHelper;
import com.gridnine.xtrip.common.parsers.helpers.PersonSearchResult;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.webservice.lenta.helpers.LentaPersonSearchContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.stream.Collectors;

public class LentaPersonParserHelper {
    public static PersonSearchResult searchPerson(LentaPersonSearchContext searchContext) {
        SearchCriterion nameCriterion = SearchCriterion.icontains((String)PersonIndex.Property.firstNameValues.name(), (String)searchContext.getFirstName().get(0));
        SearchCriterion lastNameCriterion = SearchCriterion.icontains((String)PersonIndex.Property.lastNameValues.name(), (String)searchContext.getLastName().get(0));
        SearchCriterion personnelNumberCriterion = SearchCriterion.icontains((String)PersonIndex.Property.costCodesValues.name(), (String)searchContext.getPersonnelNumber());
        SearchCriterion birthdayCriterion = SearchCriterion.eq((String)PersonIndex.Property.birthday.name(), (Object)searchContext.getBirthday());
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(nameCriterion);
        ArrayList<PersonIndex> personIndices = new ArrayList<PersonIndex>(EntityStorage.get().search(PersonIndex.class, query).getData());
        if (personIndices.size() == 0) {
            return PersonParserHelper.createNewPerson();
        }
        LentaPersonParserHelper.searchByWeakParameter(query, lastNameCriterion, personIndices);
        LentaPersonParserHelper.searchByWeakParameter(query, personnelNumberCriterion, personIndices);
        if (searchContext.getBirthday() != null) {
            LentaPersonParserHelper.searchByParameter(query, birthdayCriterion, personIndices);
        }
        if (CollectionUtil.isNotEmpty(searchContext.getPatronymic())) {
            SearchCriterion patronymicCriterion = SearchCriterion.contains((String)PersonIndex.Property.middleNameValues.name(), (Object)searchContext.getPatronymic().get(0));
            LentaPersonParserHelper.searchByWeakParameter(query, patronymicCriterion, personIndices);
        }
        if (CollectionUtil.isEmpty(personIndices)) {
            return PersonParserHelper.createNewPerson();
        }
        for (PersonIndex personIndex : personIndices) {
            EntityContainer personEntityContainer = EntityStorage.get().resolve(personIndex.getSource());
            Person person = (Person)personEntityContainer.getEntity();
            if (person.getGender() != searchContext.getGender()) continue;
            EnumMap passportDataMap = new EnumMap(PassportType.class);
            person.getPassports().stream().filter(passport -> passport.getType() != null).forEach(passport -> {
                if (!passportDataMap.containsKey(passport.getType())) {
                    passportDataMap.put(passport.getType(), new MiscUtil.Pair());
                }
                ((MiscUtil.Pair)passportDataMap.get(passport.getType())).setFirst(passport);
            });
            searchContext.getPassportDataList().stream().filter(passport -> passport.getType() != null).forEach(passport -> {
                if (!passportDataMap.containsKey(passport.getType())) {
                    passportDataMap.put(passport.getType(), new MiscUtil.Pair());
                }
                ((MiscUtil.Pair)passportDataMap.get(passport.getType())).setSecond(passport);
            });
            boolean passportsAreEquals = false;
            for (MiscUtil.Pair passportPair : passportDataMap.values()) {
                if (passportPair.getFirst() == null || passportPair.getSecond() == null || ((Passport)passportPair.getFirst()).getNumber() == null || ((LentaPersonSearchContext.PassportData)passportPair.getSecond()).getNumber() == null || !((Passport)passportPair.getFirst()).getNumber().equals(((LentaPersonSearchContext.PassportData)passportPair.getSecond()).getNumber())) continue;
                passportsAreEquals = true;
                break;
            }
            if (!passportsAreEquals) continue;
            if (CollectionUtil.isNotEmpty((Collection)person.getEmployments())) {
                List personEmployments = person.getEmployments().stream().map(PersonEmployment::getOrganization).collect(Collectors.toList());
                if (searchContext.getEmployments().stream().noneMatch(personEmployments::contains)) continue;
            }
            PersonSearchResult searchResult = new PersonSearchResult();
            searchResult.setPerson(personEntityContainer);
            searchResult.setExists(true);
            searchResult.setUnique(true);
            return searchResult;
        }
        return PersonParserHelper.createNewPerson();
    }

    private static void searchByWeakParameter(SearchQuery query, SearchCriterion criterion, List<PersonIndex> personIndices) {
        ArrayList oldCriteria = new ArrayList(query.getCriteria().getCriterions());
        query.getCriteria().getCriterions().add(criterion);
        List searchResult = EntityStorage.get().search(PersonIndex.class, query).getData();
        if (CollectionUtil.isEmpty((Collection)searchResult)) {
            query.getCriteria().getCriterions().clear();
            query.getCriteria().getCriterions().addAll(oldCriteria);
        }
        personIndices.clear();
        personIndices.addAll(searchResult);
    }

    private static void searchByParameter(SearchQuery query, SearchCriterion criterion, List<PersonIndex> personIndices) {
        query.getCriteria().getCriterions().add(criterion);
        personIndices.clear();
        personIndices.addAll(EntityStorage.get().search(PersonIndex.class, query).getData());
    }
}

