/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.webservice.lenta.helpers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.PassportCorrelationQualifier;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.parsers.model.LentaPersonWrapper;
import com.gridnine.xtrip.common.parsers.model.ParserPersonCommunication;
import com.gridnine.xtrip.common.parsers.model.ParserPersonEmployment;
import com.gridnine.xtrip.common.parsers.model.ParserPersonPassport;
import com.gridnine.xtrip.common.parsers.model.ParserPersonUdid;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.webservice.lenta.model.request.Person;
import com.gridnine.xtrip.server.ibecorp.webservice.lenta.model.request.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class LentaPersonWrapperHelper {
    public static Gender getGender(String genderName) {
        switch (genderName) {
            case "Male": {
                return Gender.MALE;
            }
            case "Female": {
                return Gender.FEMALE;
            }
        }
        return null;
    }

    public static PersonType getRole(String roleName) {
        switch (roleName) {
            case "N": {
                return PersonType.PASSENGER;
            }
        }
        return null;
    }

    public static ParserPersonUdid getReferenceValue(List<Reference> references) {
        return references.stream().map(reference -> {
            ParserPersonUdid udid = new ParserPersonUdid();
            udid.setUdidType(reference.getReferenceId());
            udid.setCostCodeValue(reference.getReferenceItemValue());
            return udid;
        }).filter(udid -> {
            try {
                int costCodeValue = Integer.parseInt(udid.getCostCodeValue());
                return costCodeValue > 0 && costCodeValue < 16;
            }
            catch (NumberFormatException ignore) {
                return false;
            }
        }).findFirst().orElse(null);
    }

    public static Organization getOrganization(String inn, String kpp) {
        EntityReference relatedOrganization = null;
        if (TextUtil.nonBlank((String)inn)) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.registrationId.name(), (Object)inn));
            List organizationIndexes = EntityStorage.get().search(OrganizationIndex.class, query).getData();
            if (organizationIndexes.size() != 0) {
                relatedOrganization = ((OrganizationIndex)organizationIndexes.get(0)).getSource();
                if (organizationIndexes.size() > 1) {
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.kpp.name(), (Object)kpp));
                    organizationIndexes.clear();
                    organizationIndexes.addAll(EntityStorage.get().search(OrganizationIndex.class, query).getData());
                    if (organizationIndexes.size() != 0) {
                        relatedOrganization = ((OrganizationIndex)organizationIndexes.get(0)).getSource();
                    }
                }
            }
        }
        if (relatedOrganization != null) {
            return (Organization)EntityStorage.get().resolve(relatedOrganization).getEntity();
        }
        return null;
    }

    public static void setEmployment(LentaPersonWrapper wrapperPerson, Organization organization) {
        ParserPersonEmployment newEmployment = new ParserPersonEmployment();
        newEmployment.setOrganizationCode(organization.getCode());
        newEmployment.setMainEmployment(true);
        wrapperPerson.setEmployment(newEmployment);
    }

    public static void setStaffId(LentaPersonWrapper wrapperPerson, String staffId, Organization organization) {
        ParserPersonUdid udid = new ParserPersonUdid();
        udid.setCostCodeOrganizationCode(organization.getCode());
        organization.getCostCodeProperties().stream().filter(costCode -> costCode.getName().equalsIgnoreCase("staffid")).findFirst().ifPresent(costCode -> {
            CostCodeCategory costCodeCategory = (CostCodeCategory)DictionaryCache.get().resolveReference(costCode.getCategory());
            udid.setUdidType(costCodeCategory.getShortName());
        });
        udid.setCostCodeValue(staffId);
        udid.setCostCodeLocalValue(staffId);
        udid.setCostCodeEnglishValue(staffId);
        udid.setUdidType("STAFFID");
        wrapperPerson.getParserPersonUdids().add(udid);
    }

    public static void setUdid(LentaPersonWrapper wrapper, ParserPersonUdid referenceValue, Organization organization) {
        if (referenceValue != null && organization != null) {
            referenceValue.setCostCodeOrganizationCode(organization.getCode());
            organization.getCostCodeProperties().stream().filter(costCode -> costCode.getName().equalsIgnoreCase(referenceValue.getUdidType())).findFirst().ifPresent(costCode -> {
                CostCodeCategory costCodeCategory = (CostCodeCategory)DictionaryCache.get().resolveReference(costCode.getCategory());
                referenceValue.setUdidType(costCodeCategory.getShortName());
                wrapper.getParserPersonUdids().add(referenceValue);
            });
        }
    }

    public static List<ParserPersonPassport> getDocuments(Person person) {
        return person.getDocuments().stream().map(doc -> {
            ParserPersonPassport document = new ParserPersonPassport();
            document.setType(LentaPersonWrapperHelper.getPassportType(doc.getType()));
            document.setNumber(doc.getSeriesNumber());
            document.setCitizenshipCode(doc.getCitizenshipCode());
            if (document.getType() == PassportType.INTERNAL) {
                document.getFirstNames().put(PassportCorrelationQualifier.CYRILLIC.name(), person.getNameRus());
                document.getLastNames().put(PassportCorrelationQualifier.CYRILLIC.name(), person.getLastNameRus());
                document.getMiddleNames().put(PassportCorrelationQualifier.CYRILLIC.name(), person.getPatronymicRus());
                document.setGender(LentaPersonWrapperHelper.getGender(person.getGender()));
                document.setBirthday(person.getBirthday());
            }
            return document;
        }).collect(Collectors.toList());
    }

    private static PassportType getPassportType(String passportTypeName) {
        switch (passportTypeName) {
            case "\u041e\u0431\u0449\u0435\u0433\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u0438\u0439 \u043f\u0430\u0441\u043f\u043e\u0440\u0442": {
                return PassportType.INTERNAL;
            }
        }
        return null;
    }

    public static List<ParserPersonCommunication> getPersonCommunications(Person person) {
        ArrayList<ParserPersonCommunication> communications = new ArrayList<ParserPersonCommunication>();
        ParserPersonCommunication email = new ParserPersonCommunication();
        email.setType(CommunicationType.EMAIL);
        email.setCommunicationSense(person.getEmail());
        communications.add(email);
        if (person.getWorPhone() != null) {
            ParserPersonCommunication phone = new ParserPersonCommunication();
            phone.setType(CommunicationType.WORK_PHONE);
            phone.setCommunicationSense(person.getWorPhone());
            communications.add(phone);
        }
        return communications;
    }

    public static boolean getIsActive(String isActive) {
        switch (isActive) {
            case "Y": {
                return true;
            }
            case "N": {
                return false;
            }
        }
        throw new IllegalArgumentException("Incorrect value");
    }
}

