/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.webservice.lenta.ibus.processing;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.CountryReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonPassportWrapper;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.l10n.Messages;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.LentaPersonWrapper;
import com.gridnine.xtrip.common.parsers.model.ParserPersonEmployment;
import com.gridnine.xtrip.common.parsers.model.ParserPersonPassport;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.webservice.lenta.ibus.IBusLentaWsKeys;
import com.gridnine.xtrip.server.ibecorp.webservice.lenta.model.LentaPersonData;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers2.person.PersonHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class LentaPersonParsePersonExchangeDataProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        LentaPersonWrapper wrapperPerson = (LentaPersonWrapper)ctx.getMandatoryObject((Enum)IBusLentaWsKeys.ENTRY_WRAPPER);
        LentaPersonData data = new LentaPersonData();
        this.parse(ctx, data, wrapperPerson);
        ctx.putObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA, (Object)data);
    }

    private void parse(MessageContext ctx, LentaPersonData data, LentaPersonWrapper wrapperPerson) {
        String code = wrapperPerson.getCode();
        Gender gender = wrapperPerson.getGender();
        Date personBirthday = wrapperPerson.getBirthday();
        L10nString lastName = wrapperPerson.getLastName();
        L10nString firstName = wrapperPerson.getFirstName();
        L10nString middleName = wrapperPerson.getMiddleName();
        PersonEmployment employment = new PersonEmployment();
        ParserPersonEmployment parserPersonEmployment = wrapperPerson.getEmployment();
        if (parserPersonEmployment != null) {
            String organizationCode = parserPersonEmployment.getOrganizationCode();
            String categoryName = parserPersonEmployment.getEmployeeCategory();
            if (TextUtil.nonBlank((String)organizationCode)) {
                List organizations = PersonHelper.getOrganizations((String)organizationCode.trim());
                if (organizations.size() > 1) {
                    List clients = organizations.stream().map(organizationEntityReference -> EntityStorage.get().resolve(organizationEntityReference)).filter(Objects::nonNull).filter(container -> container.getEntity() != null).filter(container -> ((Organization)container.getEntity()).getCode().startsWith("CL")).collect(Collectors.toList());
                    if (clients.size() > 1) {
                        ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.PersonExchangeProcessor_personEmploymentOrganizationDefineAmbiguous, (Object[])new Object[]{L10nResourcesManager.getStr((String)Messages.PersonExchangeProcessor_organizationWithCodeMultipleFound, (Object[])new Object[]{organizationCode.trim()})}));
                    } else {
                        organizations.clear();
                        organizations.addAll(clients.stream().map(EntityContainer::toReference).collect(Collectors.toList()));
                    }
                }
                if (organizations.size() > 0) {
                    EntityReference organization = (EntityReference)organizations.iterator().next();
                    employment.setOrganization(organization);
                    employment.setOpened(parserPersonEmployment.getOpened());
                    employment.setClosed(parserPersonEmployment.getClosed());
                    employment.setMainEmployment(parserPersonEmployment.isMainEmployment());
                    EntityContainer organizationEntityContainer = EntityStorage.get().resolve(organization);
                    ((Organization)organizationEntityContainer.getEntity()).getEmployeeCategories().stream().filter(employeeCategory -> employeeCategory.getName().getValues().containsValue(parserPersonEmployment.getEmployeeCategory())).findFirst().ifPresent(arg_0 -> ((PersonEmployment)employment).setEmployeeCategory(arg_0));
                    if (wrapperPerson.getReferenceValue() != null) {
                        Optional<EmployeeCategory> employeeCategory2 = ((Organization)organizationEntityContainer.getEntity()).getEmployeeCategories().stream().filter(orgEmployeeCategory -> orgEmployeeCategory.getName().getValues().containsValue(wrapperPerson.getReferenceValue())).findFirst();
                        if (employeeCategory2.isPresent()) {
                            employment.setEmployeeCategory(employeeCategory2.get());
                        } else {
                            ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)"LentaPersonParser_ByValidationCategoryDoesNotExists", (Object[])new Object[]{wrapperPerson.getReferenceValue()}));
                        }
                    }
                    if (TextUtil.nonBlank((String)categoryName)) {
                        String finalCategoryName = categoryName;
                        if (organizationEntityContainer != null) {
                            if (((Organization)organizationEntityContainer.getEntity()).getEmployeeCategories().stream().map(c -> L10nStringHelper.getValue((L10nString)c.getName(), (Locale)LocaleHelper.RU_LOCALE, (boolean)true)).anyMatch(name -> name.equals(finalCategoryName))) {
                                EmployeeCategory category = new EmployeeCategory();
                                category.getName().getValues().put(LocaleHelper.RU_LOCALE, categoryName);
                                employment.setEmployeeCategory(category);
                            } else {
                                ctx.addMessage(MessageHelper.createWarningMessage((String)Messages.PersonExchangeProcessor_personEmploymentCategoryDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.PersonExchangeProcessor_categoryWithNameNotFound, (Object[])new Object[]{categoryName, organizationCode.trim()}), (Object[])new Object[0]));
                            }
                        }
                    }
                }
            }
        }
        PersonType type = wrapperPerson.getType();
        ArrayList documents = new ArrayList();
        wrapperPerson.getDocuments().forEach(parserPersonPassport -> {
            String citizenshipCode = parserPersonPassport.getCitizenshipCode();
            CountryReference passportCitizenship = null;
            if (!TextUtil.isBlank((String)citizenshipCode)) {
                Set countries = DictHelper.findCountryByCode((String)citizenshipCode.trim());
                if (countries.size() > 1) {
                    ctx.addMessage(MessageHelper.createWarningMessage((String)Messages.PersonExchangeProcessor_personPassportCitizenshipDefineAmbiguous, (String)L10nResourcesManager.getStr((String)Messages.PersonExchangeProcessor_countryWithCodeMultipleFound, (Object[])new Object[]{citizenshipCode.trim()}), (Object[])new Object[0]));
                }
                if (countries.size() > 0) {
                    passportCitizenship = ((Country)countries.iterator().next()).toReference();
                } else {
                    ctx.addMessage(MessageHelper.createWarningMessage((String)Messages.PersonExchangeProcessor_personPassportCitizenshipDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.PersonExchangeProcessor_countryWithCodeNotFound, (Object[])new Object[]{citizenshipCode.trim()}), (Object[])new Object[0]));
                }
            }
            CountryReference passportOriginCountry = null;
            String passportOriginCountryCode = parserPersonPassport.getOriginCountryCode();
            if (TextUtil.isBlank((String)passportOriginCountryCode)) {
                passportOriginCountry = passportCitizenship;
            } else {
                Set countries = DictHelper.findCountryByCode((String)passportOriginCountryCode.trim());
                if (countries.size() > 1) {
                    ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.PersonExchangeProcessor_personPassportOriginCountryDefineAmbiguous, (Object[])new Object[]{L10nResourcesManager.getStr((String)Messages.PersonExchangeProcessor_countryWithCodeMultipleFound, (Object[])new Object[]{passportOriginCountryCode.trim()})}));
                }
                if (countries.size() > 0) {
                    passportOriginCountry = ((Country)countries.iterator().next()).toReference();
                } else {
                    ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.PersonExchangeProcessor_personPassportOriginCountryDefineFailed, (Object[])new Object[]{L10nResourcesManager.getStr((String)Messages.PersonExchangeProcessor_countryWithCodeNotFound, (Object[])new Object[]{passportOriginCountryCode.trim()})}));
                }
            }
            ArrayList resultDocuments = new ArrayList();
            HashSet qualifierNames = new HashSet();
            qualifierNames.addAll(parserPersonPassport.getFirstNames().keySet());
            qualifierNames.addAll(parserPersonPassport.getLastNames().keySet());
            qualifierNames.addAll(parserPersonPassport.getMiddleNames().keySet());
            qualifierNames.addAll(parserPersonPassport.getSecondNames().keySet());
            if (qualifierNames.size() == 1) {
                String qualifierName = (String)qualifierNames.iterator().next();
                Passport passport = PersonHelper.createPassport((ParserPersonPassport)parserPersonPassport, (DictionaryReference)passportCitizenship, (DictionaryReference)passportOriginCountry, (String)qualifierName);
                PersonPassportWrapper wrapper = new PersonPassportWrapper(passport);
                wrapper.unwrap(resultDocuments);
            } else if (qualifierNames.size() > 1) {
                String emptyTypeSecondName;
                String emptyTypeMiddleName;
                String emptyTypeLastName;
                ArrayList<Passport> currentPassports = new ArrayList<Passport>();
                Set notEmptyQualifierNames = qualifierNames.stream().filter(item -> !"EMPTY".equals(item)).collect(Collectors.toSet());
                for (String qualifierName : notEmptyQualifierNames) {
                    Passport passport = PersonHelper.createPassport((ParserPersonPassport)parserPersonPassport, (DictionaryReference)passportCitizenship, (DictionaryReference)passportOriginCountry, (String)qualifierName);
                    currentPassports.add(passport);
                }
                PersonPassportWrapper wrapper = new PersonPassportWrapper(currentPassports);
                wrapper.unwrap(resultDocuments);
                String emptyTypeFirstName = (String)parserPersonPassport.getFirstNames().get("EMPTY");
                if (TextUtil.nonBlank((String)emptyTypeFirstName)) {
                    ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)L10nResourcesManager.getStr((String)Messages.PersonExchangeProcessor_personPassportFirstNameTypeMissing, (Object[])new Object[]{parserPersonPassport.getNumber(), emptyTypeFirstName}), (Object[])new Object[0]));
                }
                if (TextUtil.nonBlank((String)(emptyTypeLastName = (String)parserPersonPassport.getLastNames().get("EMPTY")))) {
                    ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)L10nResourcesManager.getStr((String)Messages.PersonExchangeProcessor_personPassportLastNameTypeMissing, (Object[])new Object[]{parserPersonPassport.getNumber(), emptyTypeLastName}), (Object[])new Object[0]));
                }
                if (TextUtil.nonBlank((String)(emptyTypeMiddleName = (String)parserPersonPassport.getMiddleNames().get("EMPTY")))) {
                    ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)L10nResourcesManager.getStr((String)Messages.PersonExchangeProcessor_personPassportMiddleNameTypeMissing, (Object[])new Object[]{parserPersonPassport.getNumber(), emptyTypeMiddleName}), (Object[])new Object[0]));
                }
                if (TextUtil.nonBlank((String)(emptyTypeSecondName = (String)parserPersonPassport.getSecondNames().get("EMPTY")))) {
                    ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)L10nResourcesManager.getStr((String)Messages.PersonExchangeProcessor_personPassportSecondNameTypeMissing, (Object[])new Object[]{parserPersonPassport.getNumber(), emptyTypeSecondName}), (Object[])new Object[0]));
                }
            }
            if (resultDocuments.isEmpty() && (TextUtil.nonBlank((String)parserPersonPassport.getFirstName()) || TextUtil.nonBlank((String)parserPersonPassport.getLastName()) || TextUtil.nonBlank((String)parserPersonPassport.getMiddleName()) || TextUtil.nonBlank((String)parserPersonPassport.getSecondName()))) {
                Passport passport = PersonHelper.createPassport((ParserPersonPassport)parserPersonPassport, (DictionaryReference)passportCitizenship, (DictionaryReference)passportOriginCountry);
                PersonPassportWrapper wrapper = new PersonPassportWrapper(passport);
                wrapper.unwrap(resultDocuments);
            }
            resultDocuments.forEach(p -> PersonHelper.validatePassportNames((Passport)p, (MessageContext)ctx));
            documents.addAll(resultDocuments);
        });
        ArrayList communications = new ArrayList();
        wrapperPerson.getParserPersonCommunications().forEach(parserPersonCommunication -> {
            CommunicationType communicationType = parserPersonCommunication.getType();
            String communicationCountryCode = parserPersonCommunication.getCommunicationCountryCode();
            String communicationCityCode = parserPersonCommunication.getCommunicationCityCode();
            String communicationSense = parserPersonCommunication.getCommunicationSense();
            String communicationInternalNumber = parserPersonCommunication.getCommunicationInternalNumber();
            String communicationOrganizationCode = parserPersonCommunication.getCommunicationOrganizationCode();
            EntityReference communicationOrganization = null;
            if (!TextUtil.isBlank((String)communicationOrganizationCode)) {
                List organizations = PersonHelper.getOrganizations((String)communicationOrganizationCode.trim());
                if (organizations.size() > 1) {
                    ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.PersonExchangeProcessor_person\u0421ommunicationOrganizationCodeDefineAmbiguous, (Object[])new Object[]{L10nResourcesManager.getStr((String)Messages.PersonExchangeProcessor_organizationWithCodeMultipleFound, (Object[])new Object[]{communicationOrganizationCode.trim()})}));
                }
                if (organizations.size() > 0) {
                    communicationOrganization = (EntityReference)organizations.iterator().next();
                } else {
                    ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.PersonExchangeProcessor_person\u0421ommunicationOrganizationCodeDefineFailed, (Object[])new Object[]{L10nResourcesManager.getStr((String)Messages.PersonExchangeProcessor_organizationWithCodeNotFound, (Object[])new Object[]{communicationOrganizationCode.trim()})}));
                }
            }
            PersonCommunication communication = new PersonCommunication();
            communication.setType(communicationType);
            communication.setCountryCode(communicationCountryCode);
            communication.setCityCode(communicationCityCode);
            communication.setSense(communicationSense);
            communication.setInternalNumber(communicationInternalNumber);
            communication.setOrganization(communicationOrganization);
            communications.add(communication);
        });
        ArrayList costCodes = new ArrayList();
        wrapperPerson.getParserPersonUdids().forEach(parserPersonUdid -> {
            EntityReference costCodeOrganization = null;
            CostCodeProperties costCodeProperties = null;
            String costCodeOrganizationCode = parserPersonUdid.getCostCodeOrganizationCode();
            if (!TextUtil.isBlank((String)costCodeOrganizationCode)) {
                List organizations = PersonHelper.getOrganizations((String)costCodeOrganizationCode.trim());
                if (organizations.size() > 1) {
                    ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.PersonExchangeProcessor_personCostCodeOrganizationDefineAmbiguous, (Object[])new Object[]{L10nResourcesManager.getStr((String)Messages.PersonExchangeProcessor_organizationWithCodeMultipleFound, (Object[])new Object[]{costCodeOrganizationCode.trim()})}));
                }
                if (organizations.size() > 0) {
                    costCodeOrganization = (EntityReference)organizations.iterator().next();
                    String costCodePropertiesCode = parserPersonUdid.getUdidType();
                    if (!TextUtil.isBlank((String)costCodePropertiesCode)) {
                        costCodeProperties = PersonHelper.getCostCodeProperties((EntityReference)costCodeOrganization, (String)costCodePropertiesCode.trim());
                    }
                } else {
                    ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.PersonExchangeProcessor_personCostCodeOrganizationDefineFailed, (Object[])new Object[]{L10nResourcesManager.getStr((String)Messages.PersonExchangeProcessor_organizationWithCodeNotFound, (Object[])new Object[]{costCodeOrganizationCode.trim()})}));
                }
            }
            String costCodeValue = parserPersonUdid.getCostCodeValue();
            String costCodeLocalValue = parserPersonUdid.getCostCodeLocalValue();
            String costCodeEnglishValue = parserPersonUdid.getCostCodeEnglishValue();
            if (Objects.nonNull(costCodeProperties)) {
                PersonCostCode costCode = new PersonCostCode();
                costCode.setOrganization(costCodeOrganization);
                costCode.setCostCodeProperties(costCodeProperties);
                costCode.setValue(costCodeValue);
                costCode.setLocalValue(costCodeLocalValue);
                costCode.setEnglishValue(costCodeEnglishValue);
                costCodes.add(costCode);
            }
        });
        data.setCode(code);
        data.setPersonGender(gender);
        data.setPersonBirthday(personBirthday);
        data.setType(type);
        data.setLastName(lastName);
        data.setFirstName(firstName);
        data.setMiddleName(middleName);
        data.setEmployment(employment);
        data.getPassports().clear();
        data.getPassports().addAll(documents);
        data.getCommunications().clear();
        data.getCommunications().addAll(communications);
        data.getCostCodes().clear();
        data.getCostCodes().addAll(costCodes);
    }
}

