/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.webservice.lenta.ibus.processing;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.server.ibecorp.webservice.lenta.helpers.LentaPersonSearchContext;
import com.gridnine.xtrip.server.ibecorp.webservice.lenta.model.LentaPersonData;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class LentaPersonPutPersonSearchContextProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        LentaPersonData data = (LentaPersonData)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA);
        LentaPersonSearchContext searchContext = new LentaPersonSearchContext();
        for (Passport passport : data.getPassports()) {
            if (searchContext.getGender() == null && passport.getGender() != null) {
                searchContext.setGender(passport.getGender());
            }
            if (searchContext.getBirthday() == null && passport.getBirthday() != null) {
                searchContext.setBirthday(passport.getBirthday());
            }
            if (searchContext.getGender() == null || searchContext.getBirthday() == null) continue;
            break;
        }
        searchContext.getLastName().clear();
        searchContext.getLastName().addAll(data.getLastName().getValues().values());
        searchContext.getFirstName().clear();
        searchContext.getFirstName().addAll(data.getFirstName().getValues().values());
        for (Passport passport : data.getPassports()) {
            searchContext.getPassportDataList().add(searchContext.createPassportData(passport));
        }
        searchContext.getEmployments().clear();
        if (data.getEmployment() != null && data.getEmployment().getOrganization() != null) {
            searchContext.getEmployments().add((EntityReference<Organization>)data.getEmployment().getOrganization());
        }
        data.getCostCodes().stream().filter(personCostCode -> "StaffId".equalsIgnoreCase(StatisticsHelper.getUdidName((CostCodeProperties)personCostCode.getCostCodeProperties())) || "\u0442\u0430\u0431\u0435\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440".equalsIgnoreCase(StatisticsHelper.getUdidName((CostCodeProperties)personCostCode.getCostCodeProperties()))).findFirst().ifPresent(personCostCode -> searchContext.setPersonnelNumber(personCostCode.getValue()));
        ctx.putObject((Enum)IBusParsersContextKeys.SEARCH_CONTEXT, (Object)searchContext);
    }
}

