/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.webservice.lenta.ibus.processing;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.StorageException;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.helpers.PersonSearchResult;
import com.gridnine.xtrip.common.parsers.l10n.Messages;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.PersonExchangeDocument;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class LentaPersonSavePersonProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        PersonExchangeDocument exchangeDocument = (PersonExchangeDocument)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT);
        PersonSearchResult searchResult = (PersonSearchResult)context.getMandatoryObject((Enum)IBusParsersContextKeys.SEARCH_RESULT);
        if (searchResult.isExists() && !searchResult.isUnique()) {
            exchangeDocument.setHasDuplicates(true);
            ArrayList<Message> messages = new ArrayList<Message>();
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.PersonExchangeProcessor_validationProcessingFailed, (Object[])new Object[]{L10nResourcesManager.getStr((String)Messages.PersonExchangeProcessor_personValidationPersonDefineAmbiguous, (Object[])new Object[0])}));
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"Duplicates found!", (Object[])new Object[0]));
            messages.addAll(context.getMessagesReadOnly());
            context.clearMessages();
            throw new Exception("duplicates found");
        }
        if (!((Person)searchResult.getPerson().getEntity()).getPassports().isEmpty() && !searchResult.isExists()) {
            List passports = ((Person)searchResult.getPerson().getEntity()).getPassports();
            List strPass = passports.stream().map(Passport::getNumber).filter(Objects::nonNull).collect(Collectors.toList());
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrContainsStringCriterion((String)PersonIndex.Property.passportNumbers.name(), strPass));
            SearchResult personsWithSamePassportNumbers = EntityStorage.get().search(PersonIndex.class, query);
            Iterator iterator = personsWithSamePassportNumbers.getData().iterator();
            if (iterator.hasNext()) {
                PersonIndex personIndex = (PersonIndex)iterator.next();
                String samePassportNumbers = strPass.stream().filter(personIndex.getPassportNumbers()::contains).collect(Collectors.joining(", "));
                exchangeDocument.getMessages().add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.PersonExchangeProcessor_validationDuplicatePassport, (Object[])new Object[]{L10nResourcesManager.getStr((String)(samePassportNumbers + ", " + personIndex.getName()), (Object[])new Object[0])}));
                return;
            }
        }
        try {
            EntityStorage.get().save(searchResult.getPerson(), true);
            exchangeDocument.getMessages().add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"LentaPersonParser_Success", (Object[])new Object[0]));
        }
        catch (StorageException ignore) {
            exchangeDocument.getMessages().add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"LentaPersonParser_Error", (Object[])new Object[0]));
        }
    }
}

