/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.webservice.lenta.ibus.processing;

import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.helpers.PersonSearchResult;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.PersonExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;

public class LentaPersonUpdateExchangeDocumentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        PersonExchangeDocument exchangeDocument = (PersonExchangeDocument)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT);
        PersonSearchResult searchResult = (PersonSearchResult)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.SEARCH_RESULT);
        exchangeDocument.setOwner(searchResult.getPerson().toReference());
        exchangeDocument.setRelatedPerson(searchResult.getPerson().toReference());
        exchangeDocument.setHasDuplicates(searchResult.isExists() && !searchResult.isUnique());
        exchangeDocument.getMessages().clear();
        exchangeDocument.getMessages().addAll(ctx.getMessagesReadOnly());
        if (MessageHelper.hasMessages((Collection)exchangeDocument.getMessages(), (MessageType)MessageType.ERROR)) {
            exchangeDocument.setStatus(ProcessingStatus.ERROR);
        } else if (MessageHelper.hasMessages((Collection)exchangeDocument.getMessages(), (MessageType)MessageType.WARNING)) {
            exchangeDocument.setStatus(ProcessingStatus.WARNING);
        } else {
            exchangeDocument.setStatus(ProcessingStatus.OK);
        }
    }
}

