/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.webservice.lenta.ibus.processing;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.security.acl.IbeCorpAclRole;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.helpers.PersonSearchResult;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibecorp.webservice.lenta.model.LentaPersonData;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Optional;

public class LentaPersonUpdatePersonProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        LentaPersonData data = (LentaPersonData)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA);
        PersonSearchResult searchResult = (PersonSearchResult)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.SEARCH_RESULT);
        Person person = (Person)searchResult.getPerson().getEntity();
        this.update(ctx, person, data);
    }

    private void update(MessageContext ctx, Person person, LentaPersonData data) {
        person.getTypes().clear();
        person.getTypes().add(data.getType());
        person.getEmployments().clear();
        if (data.getEmployment() != null) {
            person.getEmployments().add(data.getEmployment());
        }
        if (data.getPersonGender() != null) {
            person.setGender(data.getPersonGender());
        }
        if (data.getPersonBirthday() != null) {
            person.setBirthday(data.getPersonBirthday());
        }
        person.getLastName().getValues().clear();
        person.getLastName().getValues().putAll(data.getLastName().getValues());
        person.getFirstName().getValues().clear();
        person.getFirstName().getValues().putAll(data.getFirstName().getValues());
        person.getMiddleName().getValues().clear();
        person.getMiddleName().getValues().putAll(data.getMiddleName().getValues());
        person.getPassports().clear();
        person.getPassports().addAll(data.getPassports());
        person.getCommunications().clear();
        person.getCommunications().addAll(data.getCommunications());
        person.getCostCodes().clear();
        person.getCostCodes().addAll(data.getCostCodes());
        person.setActive(data.isActive());
        if (CollectionUtil.isNotEmpty((Collection)person.getEmployments())) {
            person.getEmployments().forEach(employment -> {
                EntityReference organizationRef = employment.getOrganization();
                EntityContainer organizationCtr = EntityStorage.get().resolve(organizationRef);
                Organization organization = (Organization)organizationCtr.getEntity();
                Optional<EntityReference> ibeCorpAclRoleEntityReference = organization.getAclSettings().getOrganizationAclRoles().stream().filter(organizationAclRole -> {
                    EntityContainer ibeCorpAclRole = EntityStorage.get().resolve(organizationAclRole);
                    if (ibeCorpAclRole == null) {
                        return false;
                    }
                    IbeCorpAclRole aclRole = (IbeCorpAclRole)ibeCorpAclRole.getEntity();
                    return "\u0421\u0435\u043b\u0444\u0431\u0443\u043a\u0435\u0440".equals(aclRole.getName());
                }).findFirst();
                ibeCorpAclRoleEntityReference.ifPresent(corpAclRoleEntityReference -> person.getAclSettings().setAclRole(corpAclRoleEntityReference));
            });
        }
        if (person.getAclSettings().getAclRole() == null) {
            ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)"LentaPersonParser_ByValidationRoleDoesNotExists", (Object[])new Object[]{"\u0421\u0435\u043b\u0444\u0431\u0443\u043a\u0435\u0440"}));
        }
    }
}

