/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.webservice.lenta.ibus.processing;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.l10n.Messages;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.server.ibecorp.webservice.lenta.helpers.LentaPersonHelper;
import com.gridnine.xtrip.server.ibecorp.webservice.lenta.model.LentaPersonData;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class LentaPersonValidatePersonExchangeDataProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        LentaPersonData data = (LentaPersonData)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA);
        this.isRequiredFieldExists(ctx, "First name (ru)", L10nStringHelper.getValue((L10nString)data.getFirstName(), (Locale)LocaleHelper.RU_LOCALE));
        this.isRequiredFieldExists(ctx, "First name (en)", L10nStringHelper.getValue((L10nString)data.getFirstName(), (Locale)LocaleHelper.EN_LOCALE));
        this.isRequiredFieldExists(ctx, "Last name (ru)", L10nStringHelper.getValue((L10nString)data.getLastName(), (Locale)LocaleHelper.RU_LOCALE));
        this.isRequiredFieldExists(ctx, "Last name (en)", L10nStringHelper.getValue((L10nString)data.getLastName(), (Locale)LocaleHelper.EN_LOCALE));
        this.isRequiredFieldExists(ctx, "Gender", data.getPersonGender());
        this.isRequiredFieldExists(ctx, "Birthday", data.getPersonBirthday());
        this.isRequiredFieldExists(ctx, "Staff ID", data.getCostCodes().stream().filter(costCode -> Objects.nonNull(costCode.getCostCodeProperties().getType())));
        this.isRequiredFieldExists(ctx, "Email", data.getCommunications().stream().filter(communication -> communication.getType() == CommunicationType.EMAIL).findFirst().orElse(null));
        ArrayList<L10nString> fullName = new ArrayList<L10nString>();
        fullName.add(data.getFirstName());
        fullName.add(data.getLastName());
        Optional.ofNullable(data.getMiddleName()).ifPresent(patronymic -> {
            if (patronymic.getValues().size() != 0) {
                fullName.add((L10nString)patronymic);
            }
        });
        fullName.forEach(name -> {
            Map values = name.getValues();
            if (!LentaPersonHelper.isLatinValue((String)values.get(LocaleHelper.EN_LOCALE))) {
                ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)"LentaPersonParser_ByValidationNotEnglishName", (Object[])new Object[0]));
            }
            if (!LentaPersonHelper.isCyrillicValue((String)values.get(LocaleHelper.RU_LOCALE))) {
                ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)"LentaPersonParser_ByValidationNotCyrillicName", (Object[])new Object[0]));
            }
        });
        PersonType type = data.getType();
        if (type == null) {
            ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.PersonExchangeProcessor_validationTypeRemoved, (Object[])new Object[]{L10nResourcesManager.getStr((String)Messages.PersonExchangeProcessor_personValidationTypeEmpty, (Object[])new Object[0])}));
        }
    }

    private void isRequiredFieldExists(MessageContext ctx, String fieldName, Object value) {
        if (Objects.isNull(value)) {
            ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"LentaPersonParser_ByValidationRequiredField", (Object[])new Object[]{fieldName}));
        }
    }
}

