/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.webservice.lenta.ibus.processing;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.LentaPersonWrapper;
import com.gridnine.xtrip.server.ibecorp.webservice.lenta.helpers.LentaPersonWrapperHelper;
import com.gridnine.xtrip.server.ibecorp.webservice.lenta.model.request.Person;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;

public class LentaPersonWrapPersonProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        LentaPersonWrapper wrapper = new LentaPersonWrapper();
        Person person = (Person)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_ENTRY);
        this.wrap(person, wrapper);
        ctx.putObject("ENTRY_WRAPPER", (Object)wrapper);
    }

    private void wrap(final Person object, LentaPersonWrapper wrapper) {
        wrapper.setGender(LentaPersonWrapperHelper.getGender(object.getGender()));
        wrapper.setBirthday(object.getBirthday());
        wrapper.getFirstName().getValues().putAll(new HashMap<Locale, String>(){
            {
                this.put(LocaleHelper.RU_LOCALE, object.getNameRus());
                this.put(LocaleHelper.EN_LOCALE, object.getNameEng());
            }
        });
        wrapper.getLastName().getValues().putAll(new HashMap<Locale, String>(){
            {
                this.put(LocaleHelper.RU_LOCALE, object.getLastNameRus());
                this.put(LocaleHelper.EN_LOCALE, object.getLastNameEng());
            }
        });
        if (object.getPatronymicRus() != null) {
            wrapper.getMiddleName().getValues().putAll(new HashMap<Locale, String>(){
                {
                    this.put(LocaleHelper.RU_LOCALE, object.getPatronymicRus());
                    this.put(LocaleHelper.EN_LOCALE, object.getPatronymicEng());
                }
            });
        }
        Optional.ofNullable(object.getRole()).ifPresent(role -> wrapper.setType(LentaPersonWrapperHelper.getRole(object.getRole())));
        Organization organization = LentaPersonWrapperHelper.getOrganization(object.getInn(), object.getKpp());
        if (organization != null) {
            LentaPersonWrapperHelper.setEmployment(wrapper, organization);
            LentaPersonWrapperHelper.setStaffId(wrapper, object.getStaffId(), organization);
            object.getReferences().stream().filter(reference -> "GradeLimits".equals(reference.getReferenceId())).findFirst().flatMap(reference -> Optional.ofNullable(reference.getReferenceItemValue())).ifPresent(referenceValue -> wrapper.getEmployment().setEmployeeCategory(referenceValue));
            wrapper.setAclRole("\u0421\u0435\u043b\u0444\u0431\u0443\u043a\u0435\u0440");
        }
        wrapper.getDocuments().clear();
        wrapper.getDocuments().addAll(LentaPersonWrapperHelper.getDocuments(object));
        wrapper.getParserPersonCommunications().clear();
        wrapper.getParserPersonCommunications().addAll(LentaPersonWrapperHelper.getPersonCommunications(object));
    }
}

