/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.webservice.lenta.ibus.registration;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableNameUtil;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.PersonExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.server.ibecorp.webservice.lenta.model.parser.LentaPersonProfileStatus;
import com.gridnine.xtrip.server.ibecorp.webservice.lenta.model.request.Person;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

public class LentaPersonCreateExchangeDocumentProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        ExchangeFile file = (ExchangeFile)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_FILE);
        String checkSum = (String)context.getMandatoryObject((Enum)IBusParsersContextKeys.CHECK_SUM);
        List exchangeDocumentsList = (List)context.getMandatoryObject((Enum)IBusParsersContextKeys.REGISTRING_DOCUMENTS_LIST);
        final Person data = (Person)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_ENTRY);
        PersonExchangeDocument exchangeDocument = new PersonExchangeDocument();
        exchangeDocument.setType(file.getType());
        exchangeDocument.setContentType(ContentType.XML);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Person.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter sw = new StringWriter();
        marshaller.marshal((Object)data, (Writer)sw);
        String xmlContent = sw.toString();
        exchangeDocument.setContent(xmlContent.getBytes());
        exchangeDocument.setCreated(file.getCreated());
        exchangeDocument.setLocation(file.getLocation());
        exchangeDocument.setCheckSum(checkSum);
        exchangeDocument.setTitle(String.format("\u0424\u0438\u0437. \u043b\u0438\u0446\u043e %s %s", data.getNameRus(), data.getLastNameRus()));
        exchangeDocument.setName(String.format("\u041b\u0435\u043d\u0442\u0430 \u0444\u0438\u0437. \u043b\u0438\u0446\u043e %s %s", data.getNameRus(), data.getLastNameRus()));
        if (data.getStatus() == LentaPersonProfileStatus.ERROR) {
            exchangeDocument.setStatus(ProcessingStatus.ERROR);
        }
        exchangeDocument.setPersonName(PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)new PersonalLocalizableName(){

            public L10nString getLastName() {
                L10nString l10nString = new L10nString();
                l10nString.getValues().put(LocaleHelper.RU_LOCALE, data.getLastNameRus());
                l10nString.getValues().put(LocaleHelper.EN_LOCALE, data.getLastNameEng());
                return l10nString;
            }

            public L10nString getFirstName() {
                L10nString l10nString = new L10nString();
                l10nString.getValues().put(LocaleHelper.RU_LOCALE, data.getNameRus());
                l10nString.getValues().put(LocaleHelper.EN_LOCALE, data.getNameEng());
                return l10nString;
            }

            public L10nString getMiddleName() {
                L10nString l10nString = new L10nString();
                l10nString.getValues().put(LocaleHelper.RU_LOCALE, data.getPatronymicRus());
                l10nString.getValues().put(LocaleHelper.EN_LOCALE, data.getPatronymicEng());
                return l10nString;
            }
        }, (Locale)LocaleHelper.getCurrentLocale(), (boolean)true));
        exchangeDocument.getMessages().clear();
        exchangeDocument.getMessages().addAll(context.getMessagesReadOnly());
        exchangeDocument.getMessages().addAll(data.getMetadata().getMessages());
        if (MessageHelper.hasMessages((Collection)exchangeDocument.getMessages(), (MessageType)MessageType.ERROR)) {
            exchangeDocument.setStatus(ProcessingStatus.ERROR);
        } else if (exchangeDocument.getStatus() != ProcessingStatus.ERROR) {
            exchangeDocument.setStatus(ProcessingStatus.UNPROCESSED);
        }
        exchangeDocumentsList.add(exchangeDocument);
    }
}

