/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.webservice.lenta.ibus.registration;

import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.l10n.Messages;
import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.PersonExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;

public class LentaPersonHandleRegisterExchangeDocumentAdvice
extends BaseAdvice {
    public boolean handleException(Throwable e, MessageContext context) throws Exception {
        if (ExceptionUtil.isInterruptedError((Throwable)e)) {
            this.log.warn("interrupted exception occurred", e);
            context.putObject((Enum)IBusParsersContextKeys.INTERRUPTED_EXCEPTION_OCCURRED, (Object)Boolean.TRUE);
        }
        context.addMessage(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.PersonExchangeProcessor_registrationError, (Throwable)e, (Object[])new Object[]{e.getMessage()}));
        return true;
    }

    public void after(MessageContext context) throws Exception {
        Collection messages = context.getMessagesReadOnly();
        Boolean interruptedExceptionOccurred = (Boolean)context.getObject((Enum)IBusParsersContextKeys.INTERRUPTED_EXCEPTION_OCCURRED);
        if (MessageHelper.hasMessages((Collection)messages, (MessageType)MessageType.ERROR)) {
            ExchangeFile file = (ExchangeFile)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_FILE);
            String checkSum = (String)context.getObject((Enum)IBusParsersContextKeys.CHECK_SUM);
            PersonExchangeDocument exchangeDocument = new PersonExchangeDocument();
            exchangeDocument.setType(file.getType());
            exchangeDocument.setContentType(ContentType.XML);
            exchangeDocument.setContent(new String(file.getContent(), "utf-8").getBytes("utf-8"));
            exchangeDocument.setLocation(file.getLocation());
            exchangeDocument.setCreated(file.getCreated());
            exchangeDocument.setCheckSum(checkSum);
            exchangeDocument.setStatus(Boolean.TRUE.equals(interruptedExceptionOccurred) ? ProcessingStatus.UNPROCESSED : ProcessingStatus.ERROR);
            exchangeDocument.getMessages().clear();
            exchangeDocument.getMessages().addAll(messages);
        }
    }
}

