/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.webservice.lenta.ibus.registration;

import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import com.gridnine.xtrip.server.ibecorp.webservice.common.ibus.IBusSoapKeys;
import com.gridnine.xtrip.server.ibecorp.webservice.lenta.model.SetDataRequestWS;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class LentaPersonUpdateContextWSProcessor
extends BaseProcessor {
    private String fileType;
    private String entityType;
    private String entityIndexType;

    public void configure(Map<String, String> parameters) {
        this.fileType = parameters.get("file-type");
        this.entityType = parameters.get("entity-type");
        this.entityIndexType = parameters.get("entity-index-type");
    }

    public void process(MessageContext ctx) throws Exception {
        SetDataRequestWS request = (SetDataRequestWS)ctx.getMandatoryObject((Enum)IBusSoapKeys.REQUEST_WS);
        ExchangeFile exchangeFile = new ExchangeFile();
        exchangeFile.setCreated(new Date());
        exchangeFile.setType(this.fileType);
        exchangeFile.setLocation(String.format("LentaSoapMessage [%s]", exchangeFile.getCreated().toString()));
        exchangeFile.setContent(request.getData().getBytes());
        ctx.putObject((Enum)IBusParsersContextKeys.FILE_TYPE, (Object)this.fileType);
        ctx.putObject((Enum)IBusParsersContextKeys.REGISTRATION_PHASE, (Object)Boolean.TRUE);
        ctx.putObject((Enum)IBusParsersContextKeys.EXCHANGE_FILE, (Object)exchangeFile);
        ctx.putObject((Enum)IBusParsersContextKeys.DOCUMENT_CONTENT, (Object)exchangeFile.getContent());
        ctx.putObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_CLASS, (Object)XSHelper.getClass((String)this.entityType));
        ctx.putObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_INDEX_CLASS, (Object)XSHelper.getClass((String)this.entityIndexType));
        if (!TextUtil.isBlank((String)this.entityType)) {
            ctx.putObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_CLASS, (Object)XSHelper.getClass((String)this.entityType));
            if (TextUtil.isBlank((String)this.entityIndexType)) {
                EntityType et = MetaRegistryHelper.getEntityType((String)this.entityType);
                Collection idxs = MetaRegistryHelper.getIndexes((EntityType)et);
                if (!idxs.isEmpty()) {
                    ctx.putObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_INDEX_CLASS, (Object)XSHelper.getClass((String)((IndexType)idxs.iterator().next()).getId()));
                }
            } else {
                ctx.putObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_INDEX_CLASS, (Object)XSHelper.getClass((String)this.entityIndexType));
            }
        }
    }
}

