/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.webservice.lenta.ibus.request;

import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.ibecorp.webservice.lenta.helpers.LentaPersonHelper;
import com.gridnine.xtrip.server.ibecorp.webservice.lenta.ibus.IBusLentaWsKeys;
import com.gridnine.xtrip.server.ibecorp.webservice.lenta.model.parser.LentaPersonRequestData;
import com.gridnine.xtrip.server.ibecorp.webservice.lenta.model.request.Document;
import com.gridnine.xtrip.server.ibecorp.webservice.lenta.model.request.Person;
import com.gridnine.xtrip.server.ibecorp.webservice.lenta.model.request.Reference;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.io.ByteArrayInputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class LentaPersonParseRequestDataProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        String content = (String)ctx.getMandatoryObject((Enum)IBusLentaWsKeys.REQUEST_DATA);
        ByteArrayInputStream contentStream = new ByteArrayInputStream(content.getBytes());
        XMLInputFactory factory = XSUtil.getXMLInputFactory();
        XMLStreamReader reader = factory.createXMLStreamReader(contentStream, "utf-8");
        LentaPersonRequestData lentaPersonList = new LentaPersonRequestData();
        while (reader.hasNext()) {
            String tagName;
            if (reader.next() != 1 || TextUtil.isBlank((String)(tagName = reader.getLocalName())) || !tagName.equals("Persons")) continue;
            lentaPersonList.addAll(this.getItems(this::getPerson, reader, "Person"));
        }
        ctx.putObject((Enum)IBusLentaWsKeys.PROCESSING_OBJECTS, (Object)lentaPersonList);
    }

    private Person getPerson(XMLStreamReader reader) throws Exception {
        Person lentaPerson = new Person();
        String tagName = reader.getLocalName();
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    String propertyTag = reader.getLocalName();
                    if (TextUtil.isBlank((String)propertyTag)) break;
                    switch (propertyTag) {
                        case "NameRus": {
                            String firstNameRus = reader.getElementText();
                            if (!TextUtil.nonBlank((String)firstNameRus)) break;
                            lentaPerson.setNameRus(firstNameRus);
                            break;
                        }
                        case "NameEng": {
                            String firstNameEng = reader.getElementText();
                            if (!TextUtil.nonBlank((String)firstNameEng)) break;
                            lentaPerson.setNameEng(firstNameEng);
                            break;
                        }
                        case "LastNameRus": {
                            String lastNameRus = reader.getElementText();
                            if (!TextUtil.nonBlank((String)lastNameRus)) break;
                            lentaPerson.setLastNameRus(lastNameRus);
                            break;
                        }
                        case "LastNameEng": {
                            String lastNameEng = reader.getElementText();
                            if (!TextUtil.nonBlank((String)lastNameEng)) break;
                            lentaPerson.setLastNameEng(lastNameEng);
                            break;
                        }
                        case "PatronymicRus": {
                            String middleNameRus = reader.getElementText();
                            if (!TextUtil.nonBlank((String)middleNameRus)) break;
                            lentaPerson.setPatronymicRus(middleNameRus);
                            break;
                        }
                        case "PatronymicEng": {
                            String middleNameEng = reader.getElementText();
                            if (!TextUtil.nonBlank((String)middleNameEng)) break;
                            lentaPerson.setPatronymicEng(middleNameEng);
                            break;
                        }
                        case "Gender": {
                            String gender = reader.getElementText();
                            if (!TextUtil.nonBlank((String)gender)) break;
                            lentaPerson.setGender(gender);
                            break;
                        }
                        case "BirthDate": {
                            String personBirthdayValue = reader.getElementText();
                            if (!TextUtil.nonBlank((String)personBirthdayValue)) break;
                            try {
                                Date birthday = LentaPersonHelper.DATE_FORMAT.get().parse(personBirthdayValue.trim());
                                lentaPerson.setBirthday(birthday);
                            }
                            catch (ParseException ex) {
                                this.log.error("Person birthday parser exception :" + ex);
                            }
                            break;
                        }
                        case "StaffId": {
                            String staffId = reader.getElementText();
                            staffId = TextUtil.nonBlank((String)staffId) ? staffId.trim() : null;
                            lentaPerson.setStaffId(staffId);
                            break;
                        }
                        case "INNCompany": {
                            String inn = reader.getElementText();
                            inn = TextUtil.nonBlank((String)inn) ? inn.trim() : null;
                            lentaPerson.setInn(inn);
                            break;
                        }
                        case "KPPCompany": {
                            String kpp = reader.getElementText();
                            kpp = TextUtil.nonBlank((String)kpp) ? kpp.trim() : null;
                            lentaPerson.setKpp(kpp);
                            break;
                        }
                        case "Email": {
                            String emailValue = reader.getElementText();
                            if (!TextUtil.nonBlank((String)emailValue)) break;
                            lentaPerson.setEmail(emailValue);
                            break;
                        }
                        case "WorkPhone": {
                            String phoneNumber = reader.getElementText();
                            if (!TextUtil.nonBlank((String)phoneNumber)) break;
                            lentaPerson.setWorPhone(phoneNumber);
                            break;
                        }
                        case "IsActive": {
                            String isActive = reader.getElementText();
                            if (!TextUtil.nonBlank((String)isActive)) break;
                            lentaPerson.setIsActive(isActive);
                            break;
                        }
                        case "References": {
                            List<Reference> references = this.getItems(this::getReference, reader, "Reference");
                            lentaPerson.getReferences().clear();
                            lentaPerson.getReferences().addAll(references);
                            break;
                        }
                        case "Role": {
                            String personRole = reader.getElementText();
                            if (!TextUtil.nonBlank((String)personRole)) break;
                            lentaPerson.setRole(personRole);
                            break;
                        }
                        case "Documents": {
                            List<Document> documents = this.getItems(this::getDocument, reader, "Document");
                            lentaPerson.getDocuments().clear();
                            lentaPerson.getDocuments().addAll(documents);
                        }
                    }
                }
                case 2: {
                    if (!tagName.equals(reader.getLocalName())) break;
                    return lentaPerson;
                }
            }
        }
        return lentaPerson;
    }

    private <E> List<E> getItems(CommonFunction<XMLStreamReader, E> applier, XMLStreamReader reader, String elementName) throws Exception {
        ArrayList<E> items = new ArrayList<E>();
        String tagName = reader.getLocalName();
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    String propertyTag = reader.getLocalName();
                    if (!propertyTag.equals(elementName)) break;
                    E item = applier.apply(reader);
                    items.add(item);
                    break;
                }
                case 2: {
                    if (!tagName.equals(reader.getLocalName())) break;
                    return items;
                }
            }
        }
        return items;
    }

    private Document getDocument(XMLStreamReader reader) throws Exception {
        Document document = new Document();
        String tagName = reader.getLocalName();
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    String propertyTag = reader.getLocalName();
                    if (TextUtil.isBlank((String)propertyTag)) break;
                    switch (propertyTag) {
                        case "Type": {
                            document.setType(reader.getElementText());
                            break;
                        }
                        case "SeriesNumber": {
                            document.setSeriesNumber(reader.getElementText());
                            break;
                        }
                        case "CitizenshipCode": {
                            document.setCitizenshipCode(reader.getElementText());
                        }
                    }
                }
                case 2: {
                    if (!tagName.equals(reader.getLocalName())) break;
                    return document;
                }
            }
        }
        return document;
    }

    private Reference getReference(XMLStreamReader reader) throws Exception {
        Reference reference = new Reference();
        String tagName = reader.getLocalName();
        block12: while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    String propertyTag = reader.getLocalName();
                    if (TextUtil.isBlank((String)propertyTag)) continue block12;
                    switch (propertyTag) {
                        case "ReferenceId": {
                            reference.setReferenceId(reader.getElementText());
                            break;
                        }
                        case "ReferenceItemValue": {
                            reference.setReferenceItemValue(reader.getElementText());
                            break;
                        }
                    }
                }
                case 2: {
                    if (!tagName.equals(reader.getLocalName())) continue block12;
                    return reference;
                }
            }
        }
        return reference;
    }

    private static interface CommonFunction<XMLStreamReader, E> {
        public E apply(XMLStreamReader var1) throws Exception;
    }
}

