/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.webservice.lenta.ibus.request;

import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.ibecorp.l10n.Messages;
import com.gridnine.xtrip.server.ibecorp.webservice.lenta.ibus.IBusLentaWsKeys;
import com.gridnine.xtrip.server.ibecorp.webservice.lenta.model.parser.LentaPersonRequestData;
import com.gridnine.xtrip.server.ibecorp.webservice.lenta.model.request.Person;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;

public class LentaPersonRequiredFieldsValidationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        LentaPersonRequestData parsedPersonProfiles = (LentaPersonRequestData)ctx.getMandatoryObject((Enum)IBusLentaWsKeys.PROCESSING_OBJECTS);
        parsedPersonProfiles.forEach(personProfile -> this.validatePerson((Person)personProfile, ctx));
    }

    private void validatePerson(Person lentaPerson, MessageContext context) {
        this.checkRequiredFields(lentaPerson, context);
    }

    private void checkRequiredFields(Person lentaPerson, MessageContext context) {
        List requiredFields = Arrays.stream(lentaPerson.getClass().getDeclaredFields()).filter(field -> field.getAnnotation(XmlElement.class) != null).filter(field -> field.getAnnotation(XmlElement.class).required()).collect(Collectors.toList());
        for (Field field2 : requiredFields) {
            try {
                field2.setAccessible(true);
                Object fieldValue = field2.get(lentaPerson);
                if (fieldValue != null) continue;
                lentaPerson.addMessage(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.WS_LENTA_NO_REQUIRED_FIELDS_EXCEPTION, (Object[])new Object[]{field2.getName()}));
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }
}

