/*
 * Decompiled with CFR 0.152.
 */
package updateDictionary;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImDictionaryReader {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final String FOLDER_URL = "/home/bryzgalova/Dictionaries/ImDict/";
    private static final File stationsJSON = new File("/home/bryzgalova/Dictionaries/ImDict/RailwayStations.json");
    private static final File citiesJSON = new File("/home/bryzgalova/Dictionaries/ImDict/Cities.json");
    private static final File countriesJSON = new File("/home/bryzgalova/Dictionaries/ImDict/Countries.json");
    private static final File regionsJSON = new File("/home/bryzgalova/Dictionaries/ImDict/Regions.json");
    @JsonProperty(value="TransportNodes")
    private List<JsonRailwayStation> stations;
    @JsonProperty(value="Cities")
    private List<JsonCity> cities;
    @JsonProperty(value="Regions")
    private List<JsonCity> regions;
    @JsonProperty(value="Countries")
    private List<JsonCountry> countries;

    static List<JsonRailwayStation> getRailwayStations() throws IOException {
        ImDictionaryReader reader = (ImDictionaryReader)MAPPER.readValue(stationsJSON, ImDictionaryReader.class);
        return new ArrayList<JsonRailwayStation>(reader.stations);
    }

    static List<JsonCity> getCities() throws IOException {
        ImDictionaryReader reader = (ImDictionaryReader)MAPPER.readValue(citiesJSON, ImDictionaryReader.class);
        return new ArrayList<JsonCity>(reader.cities);
    }

    static List<JsonCountry> getCountries() throws IOException {
        ImDictionaryReader reader = (ImDictionaryReader)MAPPER.readValue(countriesJSON, ImDictionaryReader.class);
        return new ArrayList<JsonCountry>(reader.countries);
    }

    static Map<String, String> getCityToCountryMap() throws IOException {
        ImDictionaryReader reader = (ImDictionaryReader)MAPPER.readValue(citiesJSON, ImDictionaryReader.class);
        HashMap<String, String> cityToCountryMap = new HashMap<String, String>();
        for (JsonCity city : reader.cities) {
            cityToCountryMap.put(city.id, city.CountryId);
        }
        return cityToCountryMap;
    }

    static Map<String, String> getRegionToCountryMap() throws IOException {
        ImDictionaryReader reader = (ImDictionaryReader)MAPPER.readValue(regionsJSON, ImDictionaryReader.class);
        HashMap<String, String> regionToCountryMap = new HashMap<String, String>();
        for (JsonCity region : reader.regions) {
            regionToCountryMap.put(region.id, region.CountryId);
        }
        return regionToCountryMap;
    }

    static class JsonCountry {
        @JsonProperty(value="CountryId")
        String id;
        @JsonProperty(value="Alpha2Code")
        String code;
        @JsonProperty(value="NameRu")
        String nameRu;
        @JsonProperty(value="NameEn")
        String nameEn;

        JsonCountry() {
        }
    }

    static class JsonRegion {
        @JsonProperty(value="RegionId")
        String id;
        @JsonProperty(value="CountryId")
        String CountryId;
        @JsonProperty(value="NameRu")
        String nameRu;
        @JsonProperty(value="NameEn")
        String nameEn;

        JsonRegion() {
        }
    }

    static class JsonCity {
        @JsonProperty(value="CityId")
        String id;
        @JsonProperty(value="CountryId")
        String CountryId;
        @JsonProperty(value="NameRu")
        String nameRu;
        @JsonProperty(value="NameEn")
        String nameEn;
        @JsonProperty(value="ExpressCode")
        String codeExpress;
        @JsonProperty(value="Code")
        String code;

        JsonCity() {
        }
    }

    static class JsonRailwayStation {
        @JsonProperty(value="Code")
        String code;
        @JsonProperty(value="CountryId")
        String countryId;
        @JsonProperty(value="CityId")
        String cityId;
        @JsonProperty(value="RegionId")
        String regionId;
        @JsonProperty(value="NameRu")
        String nameRu;
        @JsonProperty(value="NameEn")
        String nameEn;
        @JsonProperty(value="Description")
        String description;
        @JsonProperty(value="IsSuburban")
        boolean isSuburban;
        @JsonProperty(value="Type")
        String type;
        @JsonProperty(value="PopularityIndex")
        String popularity;

        JsonRailwayStation() {
        }
    }
}

