/*
 * Decompiled with CFR 0.152.
 */
package updateDictionary;

import IBECORP1520.MOMRailwayStationsDictionaryReader;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CountryReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationVendorCard;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationVendorCardType;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.railway.dict.RailwayStationHelper;
import com.gridnine.xtrip.server.railway.test.RailwayTestBase;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Test;
import updateDictionary.ImDictionaryReader;

public class UpdateRailwayStations
extends RailwayTestBase {
    private static final String FOLDER_URL = "/home/bryzgalova/Dictionaries";
    private static final String REPORT_TEMPLATE_PATH = "/home/bryzgalova/Dictionaries/report/%s.txt";
    private static final String RAILWAY_DICTIONARY_URL = "/home/bryzgalova/Dictionaries/MOMdict/RailwayStation.xml";
    private static Set<String> CIS_COUNTRIES = new HashSet<String>();
    private static Map<String, String> CIS_COUNTRIES_ID_TO_CODE_MAP;
    private static Map<String, String> CIS_COUNTRIES_PREFIX_TO_ID_MAP;
    private static final File log;

    @Test
    public void testStations() throws Exception {
        List<ImDictionaryReader.JsonRailwayStation> imAllStations = ImDictionaryReader.getRailwayStations();
        List<RailwayStation> momAllStations = MOMRailwayStationsDictionaryReader.getStations(RAILWAY_DICTIONARY_URL);
        this.actualizeStationCountry(imAllStations);
        List<ImDictionaryReader.JsonRailwayStation> imStations = this.getCisImRailwayStation(imAllStations);
        List<RailwayStation> momStations = this.getCisMomRailwayStation(momAllStations);
        this.updateDictionary(momStations, imStations);
        List newStations = this.findNewStations(imStations, momStations).stream().map(this::createRailwayStation).collect(Collectors.toList());
        momStations.addAll(newStations);
        this.editXmlDict(this.writeDictionary(momStations, "stations"), "RailwayStation");
    }

    private File writeDictionary(List<RailwayStation> stations, String fileName) {
        String count = String.format("(%d)", stations.size());
        File file = new File(String.format(REPORT_TEMPLATE_PATH, fileName + count));
        try (FileOutputStream output = new FileOutputStream(file);){
            ((OutputStream)output).write(XSUtil.toString(stations).getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return file;
    }

    private void editXmlDict(File file, String newFileName) throws IOException {
        File log = new File("/home/bryzgalova/Dictionaries/" + newFileName + ".xml");
        try (FileOutputStream output = new FileOutputStream(log);){
            Files.newBufferedReader(file.toPath()).lines().filter(line -> !line.contains("<uid>") && !line.contains("<notUpdatable>") && !line.contains("<created>") && !line.contains("<modified>") && !line.contains("<createdBy>") && !line.contains("<modifiedBy>")).forEach(line -> {
                try {
                    output.write((line + "\n").getBytes());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void actualizeStationCountry(List<ImDictionaryReader.JsonRailwayStation> stations) throws IOException {
        Map<String, String> imRegionToCountryMap = ImDictionaryReader.getRegionToCountryMap();
        stations.stream().filter(st -> "0".equals(st.countryId) && !"0".equals(st.regionId)).forEach(st -> {
            st.countryId = imRegionToCountryMap.getOrDefault(st.regionId, "0");
        });
        Map<String, String> imCityToCountryMap = ImDictionaryReader.getCityToCountryMap();
        stations.stream().filter(st -> "0".equals(st.countryId) && !"0".equals(st.cityId)).forEach(st -> {
            st.countryId = imCityToCountryMap.getOrDefault(st.cityId, "0");
        });
        stations.stream().filter(st -> "0".equals(st.countryId)).forEach(st -> {
            st.countryId = CIS_COUNTRIES_PREFIX_TO_ID_MAP.getOrDefault(st.code.substring(0, 2), "0");
        });
    }

    private void updateDictionary(List<RailwayStation> momStations, List<ImDictionaryReader.JsonRailwayStation> imStations) throws FileNotFoundException {
        try (FileOutputStream logger = new FileOutputStream(log);){
            HashMap codeToJsonStationMap = new HashMap();
            imStations.forEach(st -> codeToJsonStationMap.put(st.code, st));
            int addRzdCount = 0;
            int changeNameCount = 0;
            for (RailwayStation station : momStations) {
                String oldName;
                if (!codeToJsonStationMap.containsKey(station.getCode())) continue;
                ImDictionaryReader.JsonRailwayStation imStation = (ImDictionaryReader.JsonRailwayStation)codeToJsonStationMap.get(station.getCode());
                if (!station.getCodeVariants().containsKey("EXPRESS")) {
                    station.getCodeVariants().put("EXPRESS", imStation.code);
                    ((OutputStream)logger).write(("\u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0441\u044f EXPRESS \u043a\u043e\u0434 \u0434\u043b\u044f (" + station.getCode() + ") " + this.getNames(station) + " \u043d\u0430 " + imStation.code + "\n").getBytes());
                }
                if (this.getRzdCard(station) == null) {
                    oldName = this.getNames(station);
                    station.getVendorCards().add(this.createRzdCard(imStation));
                    RailwayStationHelper.updateFromCards((RailwayStation)station);
                    ((OutputStream)logger).write(("\u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0420\u0416\u0414 \u0434\u043b\u044f (" + station.getCode() + ") " + oldName + ": " + (String)this.getRzdCard(station).getTranslations().getValues().get(LocaleUtil.LOCALE_RU) + "/" + (String)this.getRzdCard(station).getTranslations().getValues().get(LocaleUtil.LOCALE_EN) + "\n").getBytes());
                    ++addRzdCount;
                }
                if (!this.isDiffNames(station, imStation)) continue;
                oldName = this.getNames(station);
                RailwayStationVendorCard rzdCard = this.getRzdCard(station);
                String nameRu = this.getFullNameRu(imStation).toUpperCase();
                if (nameRu.contains("\u0420\u0410\u0417'\u0415\u0417\u0414")) {
                    nameRu = nameRu.replace("\u0420\u0410\u0417'\u0415\u0417\u0414", "\u0420\u0410\u0417\u042a\u0415\u0417\u0414");
                }
                rzdCard.getTranslations().getValues().put(LocaleUtil.LOCALE_RU, nameRu);
                rzdCard.getTranslations().getValues().put(LocaleUtil.LOCALE_EN, imStation.nameEn.toUpperCase());
                RailwayStationHelper.updateFromCards((RailwayStation)station);
                ((OutputStream)logger).write(("\u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f (" + station.getCode() + ") " + oldName + " \u043d\u0430 " + this.getNames(station) + "\n").getBytes());
                ++changeNameCount;
            }
            ((OutputStream)logger).write(("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e \u0420\u0416\u0414 \u043a\u0430\u0440\u0442\u043e\u0447\u0435\u043a: " + addRzdCount + "\n").getBytes());
            ((OutputStream)logger).write(("\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u043e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0439: " + changeNameCount + "\n").getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isDiffNames(RailwayStation momStation, ImDictionaryReader.JsonRailwayStation imStation) {
        return !momStation.getTranslations().getOrDefault(LocaleUtil.LOCALE_RU, "-").equals(this.getFullNameRu(imStation)) || !momStation.getTranslations().getOrDefault(LocaleUtil.LOCALE_EN, "-").equals(imStation.nameEn);
    }

    private List<RailwayStation> getCisMomRailwayStation(List<RailwayStation> momAllStations) {
        return momAllStations.stream().filter(st -> st.getCountry() != null && CIS_COUNTRIES.contains(st.getCountry().getCode())).collect(Collectors.toList());
    }

    private List<ImDictionaryReader.JsonRailwayStation> getCisImRailwayStation(List<ImDictionaryReader.JsonRailwayStation> imAllStations) throws IOException {
        Set<String> cisIds = CIS_COUNTRIES_ID_TO_CODE_MAP.keySet();
        return imAllStations.stream().filter(st -> cisIds.contains(st.countryId)).collect(Collectors.toList());
    }

    private static Map<String, String> getCisIdToCodeMap() throws IOException {
        List<ImDictionaryReader.JsonCountry> imAllCountries = ImDictionaryReader.getCountries();
        HashMap<String, String> cisIdToCodeMap = new HashMap<String, String>();
        imAllCountries.stream().filter(c -> CIS_COUNTRIES.contains(c.code)).forEach(c -> cisIdToCodeMap.put(c.id, c.code));
        return cisIdToCodeMap;
    }

    private RailwayStation createRailwayStation(ImDictionaryReader.JsonRailwayStation station) {
        RailwayStation railwayStation = new RailwayStation();
        railwayStation.setCode(station.code);
        railwayStation.getCodeVariants().put("EXPRESS", station.code);
        railwayStation.getVendorCards().add(this.createRzdCard(station));
        RailwayStationHelper.updateFromCards((RailwayStation)railwayStation);
        return railwayStation;
    }

    private RailwayStationVendorCard createRzdCard(ImDictionaryReader.JsonRailwayStation station) {
        RailwayStationVendorCard vendorCard = new RailwayStationVendorCard();
        vendorCard.setType(RailwayStationVendorCardType.RZD);
        vendorCard.getTranslations().getValues().put(LocaleUtil.LOCALE_RU, this.getFullNameRu(station));
        vendorCard.getTranslations().getValues().put(LocaleUtil.LOCALE_EN, station.nameEn);
        CountryReference countryRef = new CountryReference();
        countryRef.setCode(CIS_COUNTRIES_ID_TO_CODE_MAP.get(station.countryId));
        vendorCard.setCountry((DictionaryReference)countryRef);
        return vendorCard;
    }

    private String getFullNameRu(ImDictionaryReader.JsonRailwayStation st) {
        String description = TextUtil.isBlank((String)st.description) ? "" : " (" + st.description + ")";
        return st.nameRu + description;
    }

    private List<ImDictionaryReader.JsonRailwayStation> findNewStations(List<ImDictionaryReader.JsonRailwayStation> imStations, List<RailwayStation> momStations) {
        Set momStationCodes = momStations.stream().map(BaseDictionary::getCode).collect(Collectors.toSet());
        List<ImDictionaryReader.JsonRailwayStation> newStations = imStations.stream().filter(st -> !momStationCodes.contains(st.code)).collect(Collectors.toList());
        this.printJsonStations(newStations, "newJsonStations");
        return newStations;
    }

    private List<RailwayStation> findRudimentStations(List<RailwayStation> momStations, List<ImDictionaryReader.JsonRailwayStation> imStations) {
        Set inMobCodes = imStations.stream().map(st -> st.code).collect(Collectors.toSet());
        List<RailwayStation> oldStations = momStations.stream().filter(st -> !inMobCodes.contains(st.getCode())).collect(Collectors.toList());
        this.printStations(oldStations, "rudimentStations");
        return oldStations;
    }

    private List<RailwayStation> findSameStations(List<RailwayStation> momStations, List<ImDictionaryReader.JsonRailwayStation> imStations) {
        Set inMobCodes = imStations.stream().map(st -> st.code).collect(Collectors.toSet());
        List<RailwayStation> sameStations = momStations.stream().filter(st -> inMobCodes.contains(st.getCode())).collect(Collectors.toList());
        this.printStations(sameStations, "sameStations");
        return sameStations;
    }

    private void printStations(List<RailwayStation> stations, String fileName) {
        String count = String.format("(%d)", stations.size());
        File log = new File(String.format(REPORT_TEMPLATE_PATH, fileName + count));
        try (FileOutputStream logger = new FileOutputStream(log);){
            ((OutputStream)logger).write("nameRU/nameEn || (code/express/expressUZ)\n".getBytes());
            for (RailwayStation st : stations) {
                ((OutputStream)logger).write((this.getNames(st) + this.getCodes(st) + "\n").getBytes());
            }
            ((OutputStream)logger).write(("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e: " + stations.size()).getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getCodes(RailwayStation st) {
        return " (" + st.getCode() + "/" + st.getCodeVariants().getOrDefault("EXPRESS", "-") + "/" + st.getCodeVariants().getOrDefault("EXPRESS_UZ", "-") + ")";
    }

    private String getNames(RailwayStation st) {
        return st.getTranslations().getOrDefault(LocaleHelper.RU_LOCALE, "-") + "/" + st.getTranslations().getOrDefault(LocaleHelper.EN_LOCALE, "-");
    }

    private RailwayStationVendorCard getRzdCard(RailwayStation station) {
        Optional<RailwayStationVendorCard> opt = station.getVendorCards().stream().filter(st -> st.getType() == RailwayStationVendorCardType.RZD).findFirst();
        return opt.orElse(null);
    }

    private void printJsonStations(List<ImDictionaryReader.JsonRailwayStation> stations, String fileName) {
        String count = String.format("(%d)", stations.size());
        File log = new File(String.format(REPORT_TEMPLATE_PATH, fileName + count));
        try (FileOutputStream logger = new FileOutputStream(log);){
            ((OutputStream)logger).write("nameRu || code\n".getBytes());
            for (ImDictionaryReader.JsonRailwayStation st : stations) {
                ((OutputStream)logger).write((st.nameRu + " (" + st.code + ")\n").getBytes());
            }
            ((OutputStream)logger).write(("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e: " + stations.size()).getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void analyzeNames(List<RailwayStation> momStations, List<ImDictionaryReader.JsonRailwayStation> imStations) {
        HashMap imStationsMap = new HashMap();
        imStations.forEach(st -> imStationsMap.put(st.code, st));
        List<RailwayStation> sameStations = this.findSameStations(momStations, imStations);
        List diffNameStations = sameStations.stream().filter(st -> this.isDiffNames((RailwayStation)st, (ImDictionaryReader.JsonRailwayStation)imStationsMap.get(st.getCode()))).collect(Collectors.toList());
        String count = String.format("(%d)", diffNameStations.size());
        File log = new File(String.format(REPORT_TEMPLATE_PATH, "analyze/diffNameStations" + count));
        try (FileOutputStream logger = new FileOutputStream(log);){
            ((OutputStream)logger).write("MOM || IM\n".getBytes());
            for (RailwayStation st2 : diffNameStations) {
                ((OutputStream)logger).write((this.getNames(st2) + " || " + this.getFullNameRu((ImDictionaryReader.JsonRailwayStation)imStationsMap.get(st2.getCode())) + "/" + ((ImDictionaryReader.JsonRailwayStation)imStationsMap.get((Object)st2.getCode())).nameEn + " (" + st2.getCode() + ")\n").getBytes());
            }
            ((OutputStream)logger).write(("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e: " + diffNameStations.size()).getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<RailwayStation> checkCode(List<RailwayStation> momStations) {
        List<RailwayStation> diffCodeStations = momStations.stream().filter(st -> st.getCodeVariants().containsKey("EXPRESS") && !st.getCode().equals(st.getCodeVariants().get("EXPRESS")) || st.getCodeVariants().containsKey("EXPRESS_UZ") && !st.getCode().equals(st.getCodeVariants().get("EXPRESS_UZ"))).collect(Collectors.toList());
        this.printStations(diffCodeStations, "analyze/diffCodeStationsWarn");
        momStations.removeAll(diffCodeStations);
        return diffCodeStations;
    }

    private List<Path> getPaths(String url) throws IOException {
        return Files.walk(Paths.get(url, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
    }

    @Test
    public void assemblyFile() throws IOException {
        String url = "/home/bryzgalova/Dictionaries/MOMdict/RailwayStations";
        File newFile = new File(url);
        List<Path> paths = this.getPaths(url);
        ArrayList list = new ArrayList();
        for (Path path : paths) {
            long count = Files.newBufferedReader(path).lines().count();
            List list0 = Files.newBufferedReader(path).lines().skip(1L).limit(count - 2L).collect(Collectors.toList());
            list.addAll(list0);
        }
        try (FileOutputStream output = new FileOutputStream(newFile);){
            ((OutputStream)output).write("<objects>\n".getBytes());
            for (String s : list) {
                ((OutputStream)output).write((s + "\n").getBytes());
            }
            ((OutputStream)output).write("</objects>".getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        CIS_COUNTRIES_PREFIX_TO_ID_MAP = new HashMap<String, String>();
        log = new File("/home/bryzgalova/Dictionaries/report/log.txt");
        CIS_COUNTRIES.addAll(Arrays.asList("RU", "BY", "KZ", "AZ", "AM", "KG", "TJ", "UZ", "MD", "TM", "UA"));
        try {
            CIS_COUNTRIES_ID_TO_CODE_MAP = UpdateRailwayStations.getCisIdToCodeMap();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CIS_COUNTRIES_PREFIX_TO_ID_MAP.put("67", "220");
        CIS_COUNTRIES_PREFIX_TO_ID_MAP.put("59", "100");
        CIS_COUNTRIES_PREFIX_TO_ID_MAP.put("23", "144");
        CIS_COUNTRIES_PREFIX_TO_ID_MAP.put("20", "177");
        CIS_COUNTRIES_PREFIX_TO_ID_MAP.put("21", "24");
        CIS_COUNTRIES_PREFIX_TO_ID_MAP.put("29", "223");
        CIS_COUNTRIES_PREFIX_TO_ID_MAP.put("22", "224");
        CIS_COUNTRIES_PREFIX_TO_ID_MAP.put("57", "4");
        CIS_COUNTRIES_PREFIX_TO_ID_MAP.put("58", "17");
        CIS_COUNTRIES_PREFIX_TO_ID_MAP.put("27", "91");
        CIS_COUNTRIES_PREFIX_TO_ID_MAP.put("66", "208");
    }
}

