import com.gridnine.xtrip.common.model.booking.CommonProductIndex
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.search.ResultMode
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.common.util.IoUtil
import org.apache.commons.logging.LogFactory

import java.text.SimpleDateFormat
import java.util.stream.Collectors

def log = LogFactory.getLog("reports-etl")
def startDate = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss:SSS").parse("2019-01-01_00:00:00:000");
def endDate = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss:SSS").parse("2019-06-04_00:00:00:000");
def query = new SearchQuery()
query.preferredProperties.add("navigationKey")
query.criteria.criterions.add(SearchCriterion.ge("modified", startDate))
query.criteria.criterions.add(SearchCriterion.lt("modified", endDate))
query.resultMode = ResultMode.DATA_ONLY
log.debug("query prepared " + query)

def data = EntityStorage.get().search(CommonProductIndex.class, query).getData()
log.debug("data read")
def body = data.stream().map({idx ->
    return idx.getNavigationKey()
}).collect(Collectors.toList()).join(",")
log.debug("body prepared")
URL url = new URL("http://10.2.0.49:9595/compare/tickets")
URLConnection connection = url.openConnection();
connection.setDoInput(true);
connection.setDoOutput(true);
connection.setUseCaches(false);
((HttpURLConnection) connection).setRequestMethod("POST"); //$NON-NLS-1$
connection.setRequestProperty("Content-Type", //$NON-NLS-1$
        "text/html; charset=utf-8"); //$NON-NLS-1$
OutputStream os = connection.getOutputStream();
try {
    IoUtil.copyStream(new ByteArrayInputStream(body.getBytes("utf-8")),
            os, 256);
    os.flush();
} finally {
    os.close();
}
strm = new ByteArrayOutputStream();
InputStream is = connection.getInputStream();
try {
    IoUtil.copyStream(is, strm, 256);
} finally {
    is.close();
}
log.debug("request recieved");
log.debug(new String(strm.toByteArray()))