package com.gridnine.xtrip.server.ibecorp.scripts

import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.parsers.model.PersonExchangeDocumentIndex
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery

import java.text.SimpleDateFormat


int limit = 5000
int offset = 0

while (true) {
    SearchQuery searchQuery = new SearchQuery()
    searchQuery.setLimit(limit)
    searchQuery.setOffset(offset)

    SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy")

    List<SearchCriterion> baseCriteria = new ArrayList<>()

    baseCriteria.add(SearchCriterion.between(
            PersonExchangeDocumentIndex.Property.created.name(),
            dateFormat.parse("02-10-2022"),
            dateFormat.parse("02-11-2022")))

    searchQuery.getCriteria().getCriterions().addAll(baseCriteria)

    def searchResult =
            EntityStorage.get().search(PersonExchangeDocumentIndex.class, searchQuery)

    def exchangeDocumentIndices = searchResult.getData()

    if (exchangeDocumentIndices.isEmpty()) {
        break
    }

    exchangeDocumentIndices.findAll {exchangeDocumentIndex ->
        def exchangeDocumentCtr =
                EntityStorage.get().resolve(exchangeDocumentIndex.getSource())
        return exchangeDocumentCtr?.getEntity()?.getRelatedPerson() != null
    }.each {exchangeDocumentIndex ->
        def exchangeDocumentRef = exchangeDocumentIndex.getSource()
        def exchangeDocumentCtr = EntityStorage.get().resolve(exchangeDocumentRef)
        def exchangeDocument = exchangeDocumentCtr.getEntity()

        def personRef = exchangeDocument.getRelatedPerson()
        def personCtr = EntityStorage.get().resolve(personRef)

        if (personCtr != null) {
            def personName = exchangeDocument.getPersonName()
            def splitPersonName = personName.split(" ")

            if (splitPersonName.size() == 3) {
                def patronymic = splitPersonName[2]
                if (!personCtr.getEntity()?.getMiddleName()?.getValues()?.values()?.contains(patronymic)) {
                    message(String.format("Found object with incorrect matching (name %s)", personName))
                    message(String.format("Filename: %s, UID: %s", exchangeDocument.getName(), exchangeDocument.getUid()))
                    message(String.format("Organization: %s",
                            personCtr.getEntity().getEmployments()?.get(0)?.getOrganization()?.getCaption()))
                    message("")
                }
            }
        }
    }

    offset += limit
}
