package com.gridnine.xtrip.server.ibecorp.scripts

import com.gridnine.xtrip.common.util.IoUtil
import com.gridnine.xtrip.common.util.XmlUtil
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper
import com.gridnine.xtrip.common.xml.XHelper
import com.gridnine.xtrip.common.xml.XUtil
import org.w3c.dom.Element

import javax.xml.transform.dom.DOMSource
import javax.xml.transform.stream.StreamResult

/**This script set GeoLocations weights from one dictionary to another. Created for IBECORP-2180**/

File geoLocations = new File("") //Path to updated XML dictionary
def elementsWithWeight = loadElementsWithWeight()
def rootElement = getRootElementFromXml(geoLocations)
def geoLocationElements = XmlUtil.getElements(rootElement, "object")

geoLocationElements.each {
    def code = XHelper.readString(it, "code")
    for (def element : elementsWithWeight) {
        def elementCode = XHelper.readString(element, "code")
        if (code == elementCode) {
            def elm = XmlUtil.addElement(it, "weight", true, "")
            XmlUtil.setValue(elm, XHelper.readString(element, "weight"))
            break
        }
    }
}

new FileOutputStream(geoLocations).withCloseable { stream ->
    XUtil.newTransformer().transform(new DOMSource(rootElement),
            new StreamResult(stream))
}

static List<Element> loadElementsWithWeight() {
    List<Element> elementsWithWeight = new ArrayList<>()
    //I used an exported dictionary from another installation, so some of the logic below is specific to that format.
    //In any other cases, change it
    def path = "" //Path to the source dictionary whose weight we want to set in the updated dictionary
    def filePrefix = "com.gridnine.xtrip.common.model.dict.GeoLocation"

    for (int i = 0; ; i++) {
        def filePostfix = String.format("%08d", i)
        File xmlData = new File(path + filePrefix + filePostfix + ".xml")
        if (!xmlData.exists()) {
            break
        }

        def root = getRootElementFromXml(xmlData)
        XmlUtil.getElements(root, "object").each {
            def weight = XHelper.readInt(it, "weight")
            if (weight != 0) {
                elementsWithWeight.add(it)
            }
        }
    }

    return elementsWithWeight
}

static Element getRootElementFromXml(File xmlData) {
    return IoUtil.getResourceInputStream(xmlData).withCloseable {
        stream ->
            DocumentBuilderHelper.parse(XUtil.createSource(stream))
                    .getDocumentElement()
    }
}
